/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.auth;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import org.apache.custos.service.credential.store.CredentialStoreService;
import org.springframework.stereotype.Service;

@Service
public class KeyService {
    private final CredentialStoreService credentialStoreService;
    private volatile KeyPair keyPair;
    private volatile String keyID;

    public KeyService(CredentialStoreService credentialStoreService) {
        this.credentialStoreService = credentialStoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair getKeyPair() {
        if (this.keyPair == null) {
            KeyService keyService = this;
            synchronized (keyService) {
                if (this.keyPair == null) {
                    this.loadOrGenerateKeyPair();
                }
            }
        }
        return this.keyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeyID() {
        if (this.keyID == null) {
            KeyService keyService = this;
            synchronized (keyService) {
                if (this.keyID == null) {
                    this.keyID = this.computeKeyID(this.getKeyPair().getPublic());
                }
            }
        }
        return this.keyID;
    }

    private void loadOrGenerateKeyPair() {
        try {
            Map<String, String> keyData = this.credentialStoreService.retrieveKeyPair();
            if (keyData == null || keyData.isEmpty()) {
                this.generateAndStoreKeyPair();
            } else {
                this.keyPair = this.createKeyPairFromData(keyData);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load or generate key pair", e);
        }
    }

    private void generateAndStoreKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair generatedKeyPair = keyGen.generateKeyPair();
            String privateKey = Base64.getEncoder().encodeToString(generatedKeyPair.getPrivate().getEncoded());
            String publicKey = Base64.getEncoder().encodeToString(generatedKeyPair.getPublic().getEncoded());
            this.credentialStoreService.storeKeyPair(privateKey, publicKey);
            this.keyPair = generatedKeyPair;
            this.keyID = this.computeKeyID(generatedKeyPair.getPublic());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate and store key pair", e);
        }
    }

    private KeyPair createKeyPairFromData(Map<String, String> keyData) throws Exception {
        byte[] privateKeyBytes = Base64.getDecoder().decode(keyData.get("privateKey"));
        byte[] publicKeyBytes = Base64.getDecoder().decode(keyData.get("publicKey"));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        return new KeyPair(publicKey, privateKey);
    }

    private String computeKeyID(PublicKey publicKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(publicKey.getEncoded());
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute key ID", e);
        }
    }
}

