/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.management;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.iam.api.GroupRepresentation;
import org.apache.custos.core.iam.api.UserAttribute;
import org.apache.custos.core.iam.api.UserRepresentation;
import org.apache.custos.core.iam.api.UserSearchMetadata;
import org.apache.custos.core.iam.api.UserSearchRequest;
import org.apache.custos.core.identity.api.AuthToken;
import org.apache.custos.core.identity.api.GetUserManagementSATokenRequest;
import org.apache.custos.core.user.profile.api.GetAllGroupsResponse;
import org.apache.custos.core.user.profile.api.GetAllUserProfilesResponse;
import org.apache.custos.core.user.profile.api.Group;
import org.apache.custos.core.user.profile.api.GroupAttribute;
import org.apache.custos.core.user.profile.api.GroupMembership;
import org.apache.custos.core.user.profile.api.GroupRequest;
import org.apache.custos.core.user.profile.api.GroupToGroupMembership;
import org.apache.custos.core.user.profile.api.Status;
import org.apache.custos.core.user.profile.api.UserGroupMembershipTypeRequest;
import org.apache.custos.core.user.profile.api.UserProfile;
import org.apache.custos.core.user.profile.api.UserProfileRequest;
import org.apache.custos.service.exceptions.InternalServerException;
import org.apache.custos.service.iam.IamAdminService;
import org.apache.custos.service.identity.IdentityService;
import org.apache.custos.service.profile.UserProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupManagementService.class);
    private final IamAdminService iamAdminService;
    private final UserProfileService userProfileService;
    private final IdentityService identityService;

    public GroupManagementService(IamAdminService iamAdminService, UserProfileService userProfileService, IdentityService identityService) {
        this.iamAdminService = iamAdminService;
        this.userProfileService = userProfileService;
        this.identityService = identityService;
    }

    public Group createGroup(GroupRequest request) {
        try {
            Group group;
            LOGGER.debug("Request received to createGroup " + request.getGroup().getName() + " of tenant " + request.getTenantId());
            Object id = request.getGroup().getId();
            this.updateProfile(request.getClientId(), request.getClientSec(), request.getTenantId(), request.getGroup().getOwnerId());
            if (StringUtils.isNotBlank((CharSequence)id)) {
                group = Group.newBuilder().setId((String)id).build();
                GroupRequest groupRequest = GroupRequest.newBuilder().setTenantId(request.getTenantId()).setPerformedBy(request.getPerformedBy()).setGroup(group).build();
                try {
                    Group exGroup = this.userProfileService.getGroup(groupRequest);
                    if (exGroup != null && StringUtils.isNotBlank((CharSequence)exGroup.getName())) {
                        String msg = "Group already exist with given id " + (String)id;
                        LOGGER.error(msg);
                        throw new IllegalArgumentException(msg);
                    }
                }
                catch (EntityNotFoundException entityNotFoundException) {}
            } else {
                id = request.getGroup().getName().toLowerCase().replace(" ", "_") + "_" + String.valueOf(UUID.randomUUID());
            }
            group = request.getGroup().toBuilder().setId((String)id).build();
            request = request.toBuilder().setGroup(group).build();
            return this.userProfileService.createGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at createGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Group updateGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to updateGroup for  group  " + request.getGroup().getId() + " of tenant " + request.getTenantId());
            if (StringUtils.isBlank((CharSequence)request.getGroup().getId())) {
                throw new IllegalArgumentException("No Group ID was provided to update the group");
            }
            Group exGroup = this.userProfileService.getGroup(request);
            Group group = request.getGroup().toBuilder().setParentId(exGroup.getParentId()).build();
            request = request.toBuilder().setGroup(group).build();
            return this.userProfileService.updateGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at updateGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status deleteGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to deleteGroup for group " + request.getGroup().getId() + " of tenant " + request.getTenantId());
            if (StringUtils.isNotBlank((CharSequence)request.getId())) {
                Group group = request.getGroup().toBuilder().setId(request.getId()).build();
                request = request.toBuilder().setGroup(group).build();
            }
            this.userProfileService.deleteGroup(request);
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred at removeUserFromGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Group findGroup(GroupRequest request) {
        LOGGER.debug("Request received to findGroup of tenant " + request.getTenantId());
        return this.userProfileService.getGroup(request);
    }

    public GetAllGroupsResponse getAllGroups(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroups of tenant " + request.getTenantId());
            return this.userProfileService.getAllGroups(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at getAllGroups " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status addUserToGroup(GroupMembership request) {
        try {
            LOGGER.debug("Request received to addUserToGroup for  user  " + request.getUsername() + " of tenant " + request.getTenantId());
            this.updateProfile(request.getClientId(), request.getClientSec(), request.getTenantId(), request.getUsername());
            return this.userProfileService.addUserToGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding the user: " + request.getUsername() + " into the group: " + request.getGroupId();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status removeUserFromGroup(GroupMembership request) {
        try {
            LOGGER.debug("Request received to removeUserFromGroup for  user  " + request.getUsername() + " of tenant " + request.getTenantId());
            return this.userProfileService.removeUserFromGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at removeUserFromGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status addChildGroupToParentGroup(GroupToGroupMembership request) {
        try {
            LOGGER.debug("Request received to addChildGroupToParentGroup for  group  " + request.getChildId() + " to add " + request.getParentId() + " of tenant " + request.getTenantId());
            return this.userProfileService.addChildGroupToParentGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at addChildGroupToParentGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status removeChildGroupFromParentGroup(GroupToGroupMembership request) {
        try {
            LOGGER.debug("Request received to removeUserFromGroup for  group  " + request.getChildId() + " to remove " + request.getParentId() + " of tenant " + request.getTenantId());
            return this.userProfileService.removeChildGroupFromParentGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at removeChildGroupFromParentGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllGroupsResponse getAllGroupsOfUser(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroupsOfUser for  user  " + request.getProfile().getUsername() + " of tenant " + request.getTenantId());
            return this.userProfileService.getAllGroupsOfUser(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at getAllGroupsOfUser " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllGroupsResponse getAllParentGroupsOfGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllParentGroupsOfGroup for  group  " + request.getGroup().getId() + " of tenant " + request.getTenantId());
            return this.userProfileService.getAllParentGroupsOfGroup(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at getAllParentGroupsOfGroup " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllUserProfilesResponse getAllChildUsers(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllChildUsers for  group  " + request.getGroup().getId() + " of tenant " + request.getTenantId());
            return this.userProfileService.getAllChildUsers(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at getAllChildUsers " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllGroupsResponse getAllChildGroups(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllChildGroups for  group  " + request.getGroup().getId() + " of tenant " + request.getTenantId());
            return this.userProfileService.getAllChildGroups(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at getAllChildGroups " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status changeUserMembershipType(GroupMembership request) {
        try {
            LOGGER.debug("Request received to changeUserMembershipType for  user  " + request.getUsername() + " of tenant " + request.getTenantId());
            return this.userProfileService.changeUserMembershipType(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at changeUserMembershipType " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status hasAccess(GroupMembership request) {
        try {
            LOGGER.debug("Request received to hasAccess for  user  " + request.getUsername() + " of tenant " + request.getTenantId());
            return this.userProfileService.hasAccess(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at hasAccess " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status addGroupMembershipType(UserGroupMembershipTypeRequest request) {
        try {
            LOGGER.debug("Request received to addGroupMembershipType for  tenant " + request.getTenantId() + ", type " + request.getType());
            return this.userProfileService.addUserGroupMembershipType(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at addGroupMembershipType " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status removeUserGroupMembershipType(UserGroupMembershipTypeRequest request) {
        try {
            LOGGER.debug("Request received to removeUserGroupMembershipType for  tenant " + request.getTenantId() + ", type " + request.getType());
            return this.userProfileService.removeUserGroupMembershipType(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred at removeUserGroupMembershipType " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    private GroupRequest createGroup(GroupRepresentation representation, String parentId, long tenantId, String performedBy) {
        ArrayList<GroupAttribute> attributes = new ArrayList<GroupAttribute>();
        if (representation.getAttributesList() != null && !representation.getAttributesList().isEmpty()) {
            for (UserAttribute attribute : representation.getAttributesList()) {
                GroupAttribute groupAttribute = GroupAttribute.newBuilder().setKey(attribute.getKey()).addAllValue((Iterable)attribute.getValuesList()).build();
                attributes.add(groupAttribute);
            }
        }
        Group group = Group.newBuilder().setId(representation.getId()).setName(representation.getName()).addAllClientRoles((Iterable)representation.getClientRolesList()).addAllRealmRoles((Iterable)representation.getRealmRolesList()).addAllAttributes(attributes).build();
        if (parentId != null) {
            group = group.toBuilder().setParentId(parentId).build();
        }
        if (StringUtils.isNotBlank((CharSequence)representation.getOwnerId())) {
            group = group.toBuilder().setOwnerId(representation.getOwnerId()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)representation.getDescription())) {
            group = group.toBuilder().setDescription(representation.getDescription()).build();
        }
        return GroupRequest.newBuilder().setTenantId(tenantId).setPerformedBy(performedBy).setGroup(group).build();
    }

    private void updateProfile(String clientId, String clientSec, long tenantId, String username) {
        UserProfile userProfile = UserProfile.newBuilder().setUsername(username).build();
        UserProfileRequest userProfileRequest = UserProfileRequest.newBuilder().setTenantId(tenantId).setProfile(userProfile).build();
        UserProfile exUser = this.userProfileService.getUserProfile(userProfileRequest);
        if (exUser != null && exUser.getUsername().isBlank()) {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(clientId).setClientSecret(clientSec).setTenantId(tenantId).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            UserSearchMetadata userSearchMetadata = UserSearchMetadata.newBuilder().setUsername(username).build();
            UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(clientId).setTenantId(tenantId).setAccessToken(token.getAccessToken()).setUser(userSearchMetadata).build();
            UserRepresentation representation = this.iamAdminService.getUser(searchRequest);
            UserProfile profile = UserProfile.newBuilder().setUsername(username).setFirstName(representation.getFirstName()).setLastName(representation.getLastName()).setEmail(representation.getEmail()).build();
            UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setTenantId(tenantId).setProfile(profile).build();
            this.userProfileService.createUserProfile(profileRequest);
        }
    }

    private List<GroupRequest> getAllGroupRequests(List<GroupRepresentation> groupRepresentations, String parentId, long tenantId, String performedBy) {
        ArrayList<GroupRequest> groupRequests = new ArrayList<GroupRequest>();
        for (GroupRepresentation representation : groupRepresentations) {
            List<GroupRequest> list;
            GroupRequest groupRequest = this.createGroup(representation, parentId, tenantId, performedBy);
            groupRequests.add(groupRequest);
            if (representation.getSubGroupsList() == null || representation.getSubGroupsList().isEmpty() || (list = this.getAllGroupRequests(representation.getSubGroupsList(), representation.getId(), tenantId, performedBy)).isEmpty()) continue;
            groupRequests.addAll(list);
        }
        return groupRequests;
    }
}

