/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ant.dotnet.DotNetExecTask;
import org.apache.ant.dotnet.util.CollectionUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.RedirectorElement;

public class NUnitTask
extends Task {
    private String vm;
    private ArrayList testAssemblies = new ArrayList();
    private File configFile;
    private File out;
    private File err;
    private File xmlOut;
    private File transform;
    private boolean thread = false;
    private String fixture;
    private ArrayList includes = new ArrayList();
    private ArrayList excludes = new ArrayList();
    private boolean noshadow = false;
    private boolean labels = false;
    private RedirectorElement redirectorElement;
    private boolean failOnError = false;
    private String errorProperty;
    private Environment env = new Environment();

    public void setVm(String value) {
        this.vm = value;
    }

    public void setConfig(File c) {
        this.configFile = c;
    }

    public void setOut(File out) {
        this.out = out;
    }

    public void setError(File err) {
        this.err = err;
    }

    public void setXmlOut(File out) {
        this.xmlOut = out;
    }

    public void setTransform(File transform) {
        this.transform = transform;
    }

    public void setThread(boolean thread) {
        this.thread = thread;
    }

    public void setFixture(String fixture) {
        this.fixture = fixture;
    }

    public void setNoshadow(boolean noshadow) {
        this.noshadow = noshadow;
    }

    public void setLabels(boolean labels) {
        this.labels = labels;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setErrorProperty(String name) {
        this.errorProperty = name;
    }

    public void addTestAssembly(NamedElement a) {
        this.testAssemblies.add(a);
    }

    public void addInclude(NamedElement a) {
        this.includes.add(a);
    }

    public void addExclude(NamedElement a) {
        this.excludes.add(a);
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void addConfiguredRedirector(RedirectorElement redirectorElement) {
        if (this.redirectorElement != null) {
            throw new BuildException("cannot have > 1 nested <redirector>s");
        }
        this.redirectorElement = redirectorElement;
    }

    public void execute() {
        StringBuffer sb;
        if (this.testAssemblies.size() == 0) {
            throw new BuildException("You must specify at least one test assembly.");
        }
        DotNetExecTask exec = DotNetExecTask.getTask(this, this.vm, "nunit-console.exe", this.env);
        Iterator iter = this.testAssemblies.iterator();
        while (iter.hasNext()) {
            NamedElement a = (NamedElement)iter.next();
            exec.createArg().setValue(a.getName());
        }
        if (this.configFile != null) {
            exec.createArg().setValue("/config=" + this.configFile.getAbsolutePath());
        }
        exec.createArg().setValue("/nologo");
        if (this.out != null) {
            exec.createArg().setValue("/output=" + this.out.getAbsolutePath());
        }
        if (this.err != null) {
            exec.createArg().setValue("/err=" + this.err.getAbsolutePath());
        }
        if (this.xmlOut != null) {
            exec.createArg().setValue("/xml=" + this.xmlOut.getAbsolutePath());
        }
        if (this.transform != null) {
            exec.createArg().setValue("/transform=" + this.transform.getAbsolutePath());
        }
        if (this.thread) {
            exec.createArg().setValue("/thread");
        }
        if (this.noshadow) {
            exec.createArg().setValue("/noshadow");
        }
        if (this.labels) {
            exec.createArg().setValue("/labels");
        }
        if (this.fixture != null) {
            exec.createArg().setValue("/fixture=" + this.fixture);
        }
        if (this.includes.size() > 0) {
            sb = new StringBuffer("/include=");
            sb.append(CollectionUtils.flattenToString(this.includes));
            exec.createArg().setValue(sb.toString());
        }
        if (this.excludes.size() > 0) {
            sb = new StringBuffer("/exclude=");
            sb.append(CollectionUtils.flattenToString(this.excludes));
            exec.createArg().setValue(sb.toString());
        }
        if (this.redirectorElement != null) {
            exec.addConfiguredRedirector(this.redirectorElement);
        }
        exec.setFailonerror(this.failOnError);
        exec.internalSetErrorProperty(this.errorProperty);
        exec.execute();
    }

    public static class NamedElement {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String toString() {
            return this.getName();
        }
    }
}

