/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms.ctype;

import jakarta.jms.BytesMessage;
import jakarta.jms.TextMessage;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.jms.ctype.ContentTypeRule;
import org.apache.axis2.transport.jms.ctype.ContentTypeRuleSet;
import org.apache.axis2.transport.jms.ctype.DefaultRule;
import org.apache.axis2.transport.jms.ctype.MessageTypeRule;
import org.apache.axis2.transport.jms.ctype.PropertyRule;

public class ContentTypeRuleFactory {
    private ContentTypeRuleFactory() {
    }

    public static ContentTypeRule parse(OMElement element) throws AxisFault {
        String name = element.getLocalName();
        String value = element.getText();
        if (name.equals("jmsProperty")) {
            return new PropertyRule(value);
        }
        if (name.equals("textMessage")) {
            return new MessageTypeRule(TextMessage.class, value);
        }
        if (name.equals("bytesMessage")) {
            return new MessageTypeRule(BytesMessage.class, value);
        }
        if (name.equals("default")) {
            return new DefaultRule(value);
        }
        throw new AxisFault("Unknown content rule type '" + name + "'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentTypeRuleSet parse(Parameter param) throws AxisFault {
        ContentTypeRuleSet ruleSet = new ContentTypeRuleSet();
        Object value = param.getValue();
        if (value instanceof OMElement) {
            OMElement element = (OMElement)value;
            if (!element.getLocalName().equals("rules")) throw new AxisFault("Expected <rules> element");
            Iterator it = element.getChildElements();
            while (it.hasNext()) {
                ruleSet.addRule(ContentTypeRuleFactory.parse((OMElement)it.next()));
            }
            return ruleSet;
        } else {
            ruleSet.addRule(new DefaultRule((String)value));
        }
        return ruleSet;
    }
}

