/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.InputStream;
import java.util.List;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingResourceFilter
implements ResourceFilter {
    private Logger log = LoggerFactory.getLogger(ChainingResourceFilter.class);
    private List<ResourceFilter> resourceFilters;

    public ChainingResourceFilter(List<ResourceFilter> filters) {
        this.resourceFilters = filters;
    }

    @Override
    public InputStream applyFilter(InputStream resource) throws ResourceException {
        if (this.resourceFilters == null || this.resourceFilters.isEmpty()) {
            this.log.debug("No resource filters configured, nothing to do");
            return resource;
        }
        for (ResourceFilter filter : this.resourceFilters) {
            this.log.debug("Applying filter '{}'", (Object)filter.getClass().getName());
            resource = filter.applyFilter(resource);
        }
        return resource;
    }
}

