/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.ContentEncryptedElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEncryptedElementsBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        ContentEncryptedElements contentEncryptedElements = new ContentEncryptedElements(2);
        OMAttribute attrXPathVersion = element.getAttribute(SP12Constants.ATTR_XPATH_VERSION);
        if (attrXPathVersion != null) {
            contentEncryptedElements.setXPathVersion(attrXPathVersion.getAttributeValue());
        }
        Iterator iterator = element.getChildElements();
        while (iterator.hasNext()) {
            this.processElement((OMElement)iterator.next(), contentEncryptedElements);
        }
        return contentEncryptedElements;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.CONTENT_ENCRYPTED_ELEMENTS};
    }

    private void processElement(OMElement element, ContentEncryptedElements parent) {
        QName name = element.getQName();
        if (SP12Constants.XPATH.equals(name)) {
            parent.addXPathExpression(element.getText());
            Iterator namespaces = element.getNamespacesInScope();
            while (namespaces.hasNext()) {
                OMNamespace nm = (OMNamespace)namespaces.next();
                parent.addDeclaredNamespaces(nm.getNamespaceURI(), nm.getPrefix());
            }
        }
    }
}

