//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol buffer definition for session serialization files

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: session.proto

package session

import (
	fnexecution_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/fnexecution_v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Kind int32

const (
	Kind_INVALID              Kind = 0
	Kind_INSTRUCTION_REQUEST  Kind = 1
	Kind_INSTRUCTION_RESPONSE Kind = 2
	Kind_DATA_RECEIVED        Kind = 3
	Kind_DATA_SENT            Kind = 4
	Kind_LOG_ENTRIES          Kind = 5
	Kind_HEADER               Kind = 6
	Kind_FOOTER               Kind = 7
)

// Enum value maps for Kind.
var (
	Kind_name = map[int32]string{
		0: "INVALID",
		1: "INSTRUCTION_REQUEST",
		2: "INSTRUCTION_RESPONSE",
		3: "DATA_RECEIVED",
		4: "DATA_SENT",
		5: "LOG_ENTRIES",
		6: "HEADER",
		7: "FOOTER",
	}
	Kind_value = map[string]int32{
		"INVALID":              0,
		"INSTRUCTION_REQUEST":  1,
		"INSTRUCTION_RESPONSE": 2,
		"DATA_RECEIVED":        3,
		"DATA_SENT":            4,
		"LOG_ENTRIES":          5,
		"HEADER":               6,
		"FOOTER":               7,
	}
)

func (x Kind) Enum() *Kind {
	p := new(Kind)
	*p = x
	return p
}

func (x Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_session_proto_enumTypes[0].Descriptor()
}

func (Kind) Type() protoreflect.EnumType {
	return &file_session_proto_enumTypes[0]
}

func (x Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kind.Descriptor instead.
func (Kind) EnumDescriptor() ([]byte, []int) {
	return file_session_proto_rawDescGZIP(), []int{0}
}

type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version    string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`                         // version identifier of the session schema
	SdkVersion string `protobuf:"bytes,2,opt,name=sdk_version,json=sdkVersion,proto3" json:"sdk_version,omitempty"` // build information for the SDK that generated the session.
	MaxMsgLen  int64  `protobuf:"varint,3,opt,name=max_msg_len,json=maxMsgLen,proto3" json:"max_msg_len,omitempty"` // maximum length of a single entry
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_session_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_session_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_session_proto_rawDescGZIP(), []int{0}
}

func (x *Header) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Header) GetSdkVersion() string {
	if x != nil {
		return x.SdkVersion
	}
	return ""
}

func (x *Header) GetMaxMsgLen() int64 {
	if x != nil {
		return x.MaxMsgLen
	}
	return 0
}

type Footer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Footer) Reset() {
	*x = Footer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_session_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Footer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Footer) ProtoMessage() {}

func (x *Footer) ProtoReflect() protoreflect.Message {
	mi := &file_session_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Footer.ProtoReflect.Descriptor instead.
func (*Footer) Descriptor() ([]byte, []int) {
	return file_session_proto_rawDescGZIP(), []int{1}
}

type EntryHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Len  int64 `protobuf:"varint,1,opt,name=len,proto3" json:"len,omitempty"`
	Kind Kind  `protobuf:"varint,2,opt,name=kind,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Kind" json:"kind,omitempty"`
}

func (x *EntryHeader) Reset() {
	*x = EntryHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_session_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryHeader) ProtoMessage() {}

func (x *EntryHeader) ProtoReflect() protoreflect.Message {
	mi := &file_session_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryHeader.ProtoReflect.Descriptor instead.
func (*EntryHeader) Descriptor() ([]byte, []int) {
	return file_session_proto_rawDescGZIP(), []int{2}
}

func (x *EntryHeader) GetLen() int64 {
	if x != nil {
		return x.Len
	}
	return 0
}

func (x *EntryHeader) GetKind() Kind {
	if x != nil {
		return x.Kind
	}
	return Kind_INVALID
}

type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Kind" json:"kind,omitempty"`
	// Types that are assignable to Msg:
	//	*Entry_InstReq
	//	*Entry_InstResp
	//	*Entry_Elems
	//	*Entry_LogEntries
	//	*Entry_Header
	//	*Entry_Footer
	Msg       isEntry_Msg `protobuf_oneof:"msg"`
	Timestamp int64       `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_session_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_session_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_session_proto_rawDescGZIP(), []int{3}
}

func (x *Entry) GetKind() Kind {
	if x != nil {
		return x.Kind
	}
	return Kind_INVALID
}

func (m *Entry) GetMsg() isEntry_Msg {
	if m != nil {
		return m.Msg
	}
	return nil
}

func (x *Entry) GetInstReq() *fnexecution_v1.InstructionRequest {
	if x, ok := x.GetMsg().(*Entry_InstReq); ok {
		return x.InstReq
	}
	return nil
}

func (x *Entry) GetInstResp() *fnexecution_v1.InstructionResponse {
	if x, ok := x.GetMsg().(*Entry_InstResp); ok {
		return x.InstResp
	}
	return nil
}

func (x *Entry) GetElems() *fnexecution_v1.Elements {
	if x, ok := x.GetMsg().(*Entry_Elems); ok {
		return x.Elems
	}
	return nil
}

func (x *Entry) GetLogEntries() *fnexecution_v1.LogEntry_List {
	if x, ok := x.GetMsg().(*Entry_LogEntries); ok {
		return x.LogEntries
	}
	return nil
}

func (x *Entry) GetHeader() *Header {
	if x, ok := x.GetMsg().(*Entry_Header); ok {
		return x.Header
	}
	return nil
}

func (x *Entry) GetFooter() *Footer {
	if x, ok := x.GetMsg().(*Entry_Footer); ok {
		return x.Footer
	}
	return nil
}

func (x *Entry) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type isEntry_Msg interface {
	isEntry_Msg()
}

type Entry_InstReq struct {
	InstReq *fnexecution_v1.InstructionRequest `protobuf:"bytes,1000,opt,name=inst_req,json=instReq,proto3,oneof"`
}

type Entry_InstResp struct {
	InstResp *fnexecution_v1.InstructionResponse `protobuf:"bytes,1001,opt,name=inst_resp,json=instResp,proto3,oneof"`
}

type Entry_Elems struct {
	Elems *fnexecution_v1.Elements `protobuf:"bytes,1002,opt,name=elems,proto3,oneof"`
}

type Entry_LogEntries struct {
	LogEntries *fnexecution_v1.LogEntry_List `protobuf:"bytes,1003,opt,name=log_entries,json=logEntries,proto3,oneof"`
}

type Entry_Header struct {
	Header *Header `protobuf:"bytes,1004,opt,name=header,proto3,oneof"`
}

type Entry_Footer struct {
	Footer *Footer `protobuf:"bytes,1005,opt,name=footer,proto3,oneof"`
}

func (*Entry_InstReq) isEntry_Msg() {}

func (*Entry_InstResp) isEntry_Msg() {}

func (*Entry_Elems) isEntry_Msg() {}

func (*Entry_LogEntries) isEntry_Msg() {}

func (*Entry_Header) isEntry_Msg() {}

func (*Entry_Footer) isEntry_Msg() {}

var File_session_proto protoreflect.FileDescriptor

var file_session_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x3d, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x68,
	0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x11,
	0x62, 0x65, 0x61, 0x6d, 0x5f, 0x66, 0x6e, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x63, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x64, 0x6b, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x64, 0x6b, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x73,
	0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78,
	0x4d, 0x73, 0x67, 0x4c, 0x65, 0x6e, 0x22, 0x08, 0x0a, 0x06, 0x46, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x22, 0x78, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x10, 0x0a, 0x03, 0x6c, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6c, 0x65,
	0x6e, 0x12, 0x57, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x43, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xa2, 0x05, 0x0a, 0x05, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x57, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x57, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x66, 0x6e, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x69,
	0x6e, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x5a, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x66, 0x6e, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x48, 0x0a, 0x05, 0x65, 0x6c, 0x65, 0x6d, 0x73, 0x18, 0xea, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x66, 0x6e, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6c, 0x65, 0x6d, 0x73, 0x12, 0x58, 0x0a, 0x0b,
	0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0xeb, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x66, 0x6e, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0xec, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67,
	0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x60, 0x0a, 0x06, 0x66, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x18, 0xed, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73,
	0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73,
	0x73, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x06, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x05, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x2a,
	0x91, 0x01, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x53, 0x54, 0x52, 0x55, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x49, 0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45,
	0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x4f,
	0x47, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x49, 0x45, 0x53, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x48,
	0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x4f, 0x4f, 0x54, 0x45,
	0x52, 0x10, 0x07, 0x42, 0x4e, 0x5a, 0x4c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73, 0x64,
	0x6b, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x63,
	0x6f, 0x72, 0x65, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x68, 0x61, 0x72, 0x6e,
	0x65, 0x73, 0x73, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_session_proto_rawDescOnce sync.Once
	file_session_proto_rawDescData = file_session_proto_rawDesc
)

func file_session_proto_rawDescGZIP() []byte {
	file_session_proto_rawDescOnce.Do(func() {
		file_session_proto_rawDescData = protoimpl.X.CompressGZIP(file_session_proto_rawDescData)
	})
	return file_session_proto_rawDescData
}

var file_session_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_session_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_session_proto_goTypes = []interface{}{
	(Kind)(0),           // 0: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Kind
	(*Header)(nil),      // 1: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Header
	(*Footer)(nil),      // 2: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Footer
	(*EntryHeader)(nil), // 3: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.EntryHeader
	(*Entry)(nil),       // 4: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry
	(*fnexecution_v1.InstructionRequest)(nil),  // 5: org.apache.beam.model.fn_execution.v1.InstructionRequest
	(*fnexecution_v1.InstructionResponse)(nil), // 6: org.apache.beam.model.fn_execution.v1.InstructionResponse
	(*fnexecution_v1.Elements)(nil),            // 7: org.apache.beam.model.fn_execution.v1.Elements
	(*fnexecution_v1.LogEntry_List)(nil),       // 8: org.apache.beam.model.fn_execution.v1.LogEntry.List
}
var file_session_proto_depIdxs = []int32{
	0, // 0: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.EntryHeader.kind:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Kind
	0, // 1: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.kind:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Kind
	5, // 2: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.inst_req:type_name -> org.apache.beam.model.fn_execution.v1.InstructionRequest
	6, // 3: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.inst_resp:type_name -> org.apache.beam.model.fn_execution.v1.InstructionResponse
	7, // 4: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.elems:type_name -> org.apache.beam.model.fn_execution.v1.Elements
	8, // 5: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.log_entries:type_name -> org.apache.beam.model.fn_execution.v1.LogEntry.List
	1, // 6: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.header:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Header
	2, // 7: org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Entry.footer:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.harness.session.Footer
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_session_proto_init() }
func file_session_proto_init() {
	if File_session_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_session_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_session_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Footer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_session_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_session_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_session_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Entry_InstReq)(nil),
		(*Entry_InstResp)(nil),
		(*Entry_Elems)(nil),
		(*Entry_LogEntries)(nil),
		(*Entry_Header)(nil),
		(*Entry_Footer)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_session_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_session_proto_goTypes,
		DependencyIndexes: file_session_proto_depIdxs,
		EnumInfos:         file_session_proto_enumTypes,
		MessageInfos:      file_session_proto_msgTypes,
	}.Build()
	File_session_proto = out.File
	file_session_proto_rawDesc = nil
	file_session_proto_goTypes = nil
	file_session_proto_depIdxs = nil
}
