/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.Iterators;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Name;

public abstract class Scope {
    public final Symbol owner;
    private static final Filter<Symbol> noFilter = null;
    ScopeListenerList listeners = new ScopeListenerList();

    protected Scope(Symbol owner) {
        this.owner = owner;
    }

    public final Iterable<Symbol> getSymbols() {
        return this.getSymbols(noFilter);
    }

    public final Iterable<Symbol> getSymbols(Filter<Symbol> sf) {
        return this.getSymbols(sf, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbols(LookupKind lookupKind) {
        return this.getSymbols(noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbols(Filter<Symbol> var1, LookupKind var2);

    public final Iterable<Symbol> getSymbolsByName(Name name) {
        return this.getSymbolsByName(name, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> sf) {
        return this.getSymbolsByName(name, sf, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, LookupKind lookupKind) {
        return this.getSymbolsByName(name, noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbolsByName(Name var1, Filter<Symbol> var2, LookupKind var3);

    public final Symbol findFirst(Name name) {
        return this.findFirst(name, noFilter);
    }

    public Symbol findFirst(Name name, Filter<Symbol> sf) {
        Iterator<Symbol> it = this.getSymbolsByName(name, sf).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public boolean anyMatch(Filter<Symbol> filter) {
        return this.getSymbols(filter, LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public boolean includes(final Symbol sym) {
        return this.getSymbolsByName(sym.name, new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol t) {
                return t == sym;
            }
        }).iterator().hasNext();
    }

    public boolean isEmpty() {
        return !this.getSymbols(LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public abstract Scope getOrigin(Symbol var1);

    public abstract boolean isStaticallyImported(Symbol var1);

    public static class ErrorScope
    extends ScopeImpl {
        ErrorScope(ScopeImpl next, Symbol errSymbol, Entry[] table) {
            super(next, errSymbol, table);
        }

        public ErrorScope(Symbol errSymbol) {
            super(errSymbol);
        }

        @Override
        public WriteableScope dup(Symbol newOwner) {
            return new ErrorScope(this, newOwner, this.table);
        }

        @Override
        public WriteableScope dupUnshared(Symbol newOwner) {
            return new ErrorScope(this, newOwner, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry e = super.lookup(name);
            if (e.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return e;
        }
    }

    public static class CompoundScope
    extends Scope
    implements ScopeListener {
        List<Scope> subScopes = List.nil();
        private int mark = 0;

        public CompoundScope(Symbol owner) {
            super(owner);
        }

        public void prependSubScope(Scope that) {
            if (that != null) {
                this.subScopes = this.subScopes.prepend(that);
                that.listeners.add(this);
                ++this.mark;
                this.listeners.symbolAdded(null, this);
            }
        }

        @Override
        public void symbolAdded(Symbol sym, Scope s) {
            ++this.mark;
            this.listeners.symbolAdded(sym, s);
        }

        @Override
        public void symbolRemoved(Symbol sym, Scope s) {
            ++this.mark;
            this.listeners.symbolRemoved(sym, s);
        }

        public int getMark() {
            return this.mark;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("CompoundScope{");
            String sep = "";
            for (Scope s : this.subScopes) {
                buf.append(sep);
                buf.append(s);
                sep = ",";
            }
            buf.append("}");
            return buf.toString();
        }

        @Override
        public Iterable<Symbol> getSymbols(Filter<Symbol> sf, LookupKind lookupKind) {
            return () -> Iterators.createCompoundIterator(this.subScopes, scope -> scope.getSymbols(sf, lookupKind).iterator());
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> sf, LookupKind lookupKind) {
            return () -> Iterators.createCompoundIterator(this.subScopes, scope -> scope.getSymbolsByName(name, sf, lookupKind).iterator());
        }

        @Override
        public Scope getOrigin(Symbol sym) {
            for (Scope delegate : this.subScopes) {
                if (!delegate.includes(sym)) continue;
                return delegate.getOrigin(sym);
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol sym) {
            for (Scope delegate : this.subScopes) {
                if (!delegate.includes(sym)) continue;
                return delegate.isStaticallyImported(sym);
            }
            return false;
        }
    }

    private static class FilterImportScope
    extends Scope {
        private final Types types;
        private final Scope origin;
        private final Name filterName;
        private final ImportFilter filter;
        private final JCTree.JCImport imp;
        private final BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public FilterImportScope(Types types, Scope origin, Name filterName, ImportFilter filter, JCTree.JCImport imp, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler) {
            super(origin.owner);
            this.types = types;
            this.origin = origin;
            this.filterName = filterName;
            this.filter = filter;
            this.imp = imp;
            this.cfHandler = cfHandler;
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> sf, final LookupKind lookupKind) {
            if (this.filterName != null) {
                return this.getSymbolsByName(this.filterName, sf, lookupKind);
            }
            try {
                SymbolImporter si = new SymbolImporter(this.imp.staticImport){

                    @Override
                    Iterable<Symbol> doLookup(Symbol.TypeSymbol tsym) {
                        return tsym.members().getSymbols(sf, lookupKind);
                    }
                };
                return si.importFrom((Symbol.TypeSymbol)this.origin.owner)::iterator;
            }
            catch (Symbol.CompletionFailure cf) {
                this.cfHandler.accept(this.imp, cf);
                return Collections.emptyList();
            }
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> sf, final LookupKind lookupKind) {
            if (this.filterName != null && this.filterName != name) {
                return Collections.emptyList();
            }
            try {
                SymbolImporter si = new SymbolImporter(this.imp.staticImport){

                    @Override
                    Iterable<Symbol> doLookup(Symbol.TypeSymbol tsym) {
                        return tsym.members().getSymbolsByName(name, sf, lookupKind);
                    }
                };
                return si.importFrom((Symbol.TypeSymbol)this.origin.owner)::iterator;
            }
            catch (Symbol.CompletionFailure cf) {
                this.cfHandler.accept(this.imp, cf);
                return Collections.emptyList();
            }
        }

        @Override
        public Scope getOrigin(Symbol byName) {
            return this.origin;
        }

        @Override
        public boolean isStaticallyImported(Symbol byName) {
            return this.imp.staticImport;
        }

        abstract class SymbolImporter {
            Set<Symbol> processed = new HashSet<Symbol>();
            List<Iterable<Symbol>> delegates = List.nil();
            final boolean inspectSuperTypes;

            public SymbolImporter(boolean inspectSuperTypes) {
                this.inspectSuperTypes = inspectSuperTypes;
            }

            Stream<Symbol> importFrom(Symbol.TypeSymbol tsym) {
                if (tsym == null || !this.processed.add(tsym)) {
                    return Stream.empty();
                }
                Stream<Object> result = Stream.empty();
                if (this.inspectSuperTypes) {
                    result = this.importFrom(((FilterImportScope)FilterImportScope.this).types.supertype((Type)tsym.type).tsym);
                    for (Type t : FilterImportScope.this.types.interfaces(tsym.type)) {
                        result = Stream.concat(this.importFrom(t.tsym), result);
                    }
                }
                return Stream.concat(StreamSupport.stream(this.doLookup(tsym).spliterator(), false).filter(s -> FilterImportScope.this.filter.accepts(FilterImportScope.this.origin, (Symbol)s)), result);
            }

            abstract Iterable<Symbol> doLookup(Symbol.TypeSymbol var1);
        }
    }

    public static interface ImportFilter {
        public boolean accepts(Scope var1, Symbol var2);
    }

    public static class StarImportScope
    extends ImportScope {
        public StarImportScope(Symbol owner) {
            super(owner);
        }

        public void importAll(Types types, Scope origin, ImportFilter filter, JCTree.JCImport imp, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler) {
            for (Scope existing : this.subScopes) {
                Assert.check(existing instanceof FilterImportScope);
                FilterImportScope fis = (FilterImportScope)existing;
                if (fis.origin != origin || fis.filter != filter || ((FilterImportScope)fis).imp.staticImport != imp.staticImport) continue;
                return;
            }
            this.prependSubScope(new FilterImportScope(types, origin, null, filter, imp, cfHandler));
        }

        public boolean isFilled() {
            return this.subScopes.nonEmpty();
        }
    }

    public static class NamedImportScope
    extends ImportScope {
        public NamedImportScope(Symbol owner, Scope currentFileScope) {
            super(owner);
            this.prependSubScope(currentFileScope);
        }

        public Scope importByName(Types types, Scope origin, Name name, ImportFilter filter, JCTree.JCImport imp, BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler) {
            return this.appendScope(new FilterImportScope(types, origin, name, filter, imp, cfHandler));
        }

        public Scope importType(Scope delegate, Scope origin, Symbol sym) {
            return this.appendScope(new SingleEntryScope(delegate.owner, sym, origin));
        }

        private Scope appendScope(Scope newScope) {
            List existingScopes = this.subScopes.reverse();
            this.subScopes = List.of(existingScopes.head);
            this.subScopes = this.subScopes.prepend(newScope);
            for (Scope s : existingScopes.tail) {
                this.subScopes = this.subScopes.prepend(s);
            }
            return newScope;
        }

        private static class SingleEntryScope
        extends Scope {
            private final Symbol sym;
            private final List<Symbol> content;
            private final Scope origin;

            public SingleEntryScope(Symbol owner, Symbol sym, Scope origin) {
                super(owner);
                this.sym = sym;
                this.content = List.of(sym);
                this.origin = origin;
            }

            @Override
            public Iterable<Symbol> getSymbols(Filter<Symbol> sf, LookupKind lookupKind) {
                return sf == null || sf.accepts(this.sym) ? this.content : Collections.emptyList();
            }

            @Override
            public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> sf, LookupKind lookupKind) {
                return this.sym.name == name && (sf == null || sf.accepts(this.sym)) ? this.content : Collections.emptyList();
            }

            @Override
            public Scope getOrigin(Symbol byName) {
                return this.sym == byName ? this.origin : null;
            }

            @Override
            public boolean isStaticallyImported(Symbol byName) {
                return false;
            }
        }
    }

    public static class ImportScope
    extends CompoundScope {
        public ImportScope(Symbol owner) {
            super(owner);
        }

        public void finalizeScope() {
            List scopes = this.subScopes;
            while (scopes.nonEmpty()) {
                Scope impScope = (Scope)scopes.head;
                if (impScope instanceof FilterImportScope && impScope.owner.kind == Kinds.Kind.TYP) {
                    WriteableScope finalized = WriteableScope.create(impScope.owner);
                    for (Symbol sym : impScope.getSymbols()) {
                        finalized.enter(sym);
                    }
                    finalized.listeners.add(new ScopeListener(){

                        @Override
                        public void symbolAdded(Symbol sym, Scope s) {
                            Assert.error("The scope is sealed.");
                        }

                        @Override
                        public void symbolRemoved(Symbol sym, Scope s) {
                            Assert.error("The scope is sealed.");
                        }
                    });
                    scopes.head = finalized;
                }
                scopes = scopes.tail;
            }
        }
    }

    private static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.sym = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> sf) {
            if (this.shadowed.sym == null || sf == null || sf.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(sf);
        }
    }

    private static class ScopeImpl
    extends WriteableScope {
        private int shared;
        public ScopeImpl next;
        Entry[] table;
        int hashMask;
        public Entry elems;
        int nelems = 0;
        private static final Entry sentinel = new Entry(null, null, null, null);
        private static final int INITIAL_SIZE = 16;

        private ScopeImpl(ScopeImpl next, Symbol owner, Entry[] table) {
            super(owner);
            this.next = next;
            Assert.check(owner != null);
            this.table = table;
            this.hashMask = table.length - 1;
        }

        private ScopeImpl(ScopeImpl next, Symbol owner, Entry[] table, int nelems) {
            this(next, owner, table);
            this.nelems = nelems;
        }

        public ScopeImpl(Symbol owner) {
            this(null, owner, new Entry[16]);
        }

        @Override
        public WriteableScope dup(Symbol newOwner) {
            ScopeImpl result = new ScopeImpl(this, newOwner, this.table, this.nelems);
            ++this.shared;
            return result;
        }

        @Override
        public WriteableScope dupUnshared(Symbol newOwner) {
            if (this.shared > 0) {
                Set acceptScopes = Collections.newSetFromMap(new IdentityHashMap());
                ScopeImpl c = this;
                while (c != null) {
                    acceptScopes.add(c);
                    c = c.next;
                }
                int n = 0;
                Entry[] oldTable = this.table;
                Entry[] newTable = new Entry[this.table.length];
                for (int i = 0; i < oldTable.length; ++i) {
                    Entry e = oldTable[i];
                    while (e != null && e != sentinel && !acceptScopes.contains(e.scope)) {
                        e = e.shadowed;
                    }
                    if (e == null) continue;
                    ++n;
                    newTable[i] = e;
                }
                return new ScopeImpl(this, newOwner, newTable, n);
            }
            return new ScopeImpl(this, newOwner, (Entry[])this.table.clone(), this.nelems);
        }

        @Override
        public WriteableScope leave() {
            Assert.check(this.shared == 0);
            if (this.table != this.next.table) {
                return this.next;
            }
            while (this.elems != null) {
                int hash = this.getIndex(this.elems.sym.name);
                Entry e = this.table[hash];
                Assert.check(e == this.elems, this.elems.sym);
                this.table[hash] = this.elems.shadowed;
                this.elems = this.elems.sibling;
            }
            Assert.check(this.next.shared > 0);
            --this.next.shared;
            this.next.nelems = this.nelems;
            return this.next;
        }

        private void dble() {
            Assert.check(this.shared == 0);
            Entry[] oldtable = this.table;
            Entry[] newtable = new Entry[oldtable.length * 2];
            ScopeImpl s = this;
            while (s != null) {
                if (s.table == oldtable) {
                    Assert.check(s == this || s.shared != 0);
                    s.table = newtable;
                    s.hashMask = newtable.length - 1;
                }
                s = s.next;
            }
            int n = 0;
            int i = oldtable.length;
            while (--i >= 0) {
                Entry e = oldtable[i];
                if (e == null || e == sentinel) continue;
                this.table[this.getIndex((Name)e.sym.name)] = e;
                ++n;
            }
            this.nelems = n;
        }

        @Override
        public void enter(Symbol sym) {
            Entry e;
            int hash;
            Entry old;
            Assert.check(this.shared == 0);
            if (this.nelems * 3 >= this.hashMask * 2) {
                this.dble();
            }
            if ((old = this.table[hash = this.getIndex(sym.name)]) == null) {
                old = sentinel;
                ++this.nelems;
            }
            this.table[hash] = e = new Entry(sym, old, this.elems, this);
            this.elems = e;
            this.listeners.symbolAdded(sym, this);
        }

        @Override
        public void remove(Symbol sym) {
            Assert.check(this.shared == 0);
            Entry e = this.lookup(sym.name, candidate -> candidate == sym);
            if (e.scope == null) {
                return;
            }
            int i = this.getIndex(sym.name);
            Entry te = this.table[i];
            if (te == e) {
                this.table[i] = e.shadowed;
            } else {
                while (true) {
                    if (te.shadowed == e) {
                        te.shadowed = e.shadowed;
                        break;
                    }
                    te = te.shadowed;
                }
            }
            te = this.elems;
            if (te == e) {
                this.elems = e.sibling;
            } else {
                while (true) {
                    if (te.sibling == e) {
                        te.sibling = e.sibling;
                        break;
                    }
                    te = te.sibling;
                }
            }
            this.listeners.symbolRemoved(sym, this);
        }

        @Override
        public void enterIfAbsent(Symbol sym) {
            Assert.check(this.shared == 0);
            Entry e = this.lookup(sym.name);
            while (e.scope == this && e.sym.kind != sym.kind) {
                e = e.next();
            }
            if (e.scope != this) {
                this.enter(sym);
            }
        }

        @Override
        public boolean includes(Symbol c) {
            Entry e = this.lookup(c.name);
            while (e.scope == this) {
                if (e.sym == c) {
                    return true;
                }
                e = e.next();
            }
            return false;
        }

        protected Entry lookup(Name name) {
            return this.lookup(name, noFilter);
        }

        protected Entry lookup(Name name, Filter<Symbol> sf) {
            Entry e = this.table[this.getIndex(name)];
            if (e == null || e == sentinel) {
                return sentinel;
            }
            while (e.scope != null && (e.sym.name != name || sf != null && !sf.accepts(e.sym))) {
                e = e.shadowed;
            }
            return e;
        }

        @Override
        public Symbol findFirst(Name name, Filter<Symbol> sf) {
            return this.lookup((Name)name, sf).sym;
        }

        int getIndex(Name name) {
            int h = name.hashCode();
            int i = h & this.hashMask;
            int x = this.hashMask - (h + (h >> 16) << 1);
            int d = -1;
            Entry e;
            while ((e = this.table[i]) != null) {
                if (e == sentinel) {
                    if (d < 0) {
                        d = i;
                    }
                } else if (e.sym.name == name) {
                    return i;
                }
                i = i + x & this.hashMask;
            }
            return d >= 0 ? d : i;
        }

        @Override
        public boolean anyMatch(Filter<Symbol> sf) {
            return this.getSymbols(sf, LookupKind.NON_RECURSIVE).iterator().hasNext();
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> sf, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new Iterator<Symbol>(){
                        private ScopeImpl currScope;
                        private Entry currEntry;
                        {
                            this.currScope = this;
                            this.currEntry = elems;
                            this.update();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currEntry != null;
                        }

                        @Override
                        public Symbol next() {
                            Symbol sym;
                            Symbol symbol = sym = this.currEntry == null ? null : this.currEntry.sym;
                            if (this.currEntry != null) {
                                this.currEntry = this.currEntry.sibling;
                            }
                            this.update();
                            return sym;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void update() {
                            this.skipToNextMatchingEntry();
                            if (lookupKind == LookupKind.RECURSIVE) {
                                while (this.currEntry == null && this.currScope.next != null) {
                                    this.currScope = this.currScope.next;
                                    this.currEntry = this.currScope.elems;
                                    this.skipToNextMatchingEntry();
                                }
                            }
                        }

                        void skipToNextMatchingEntry() {
                            while (this.currEntry != null && sf != null && !sf.accepts(this.currEntry.sym)) {
                                this.currEntry = this.currEntry.sibling;
                            }
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> sf, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new Iterator<Symbol>(){
                        Entry currentEntry;
                        {
                            this.currentEntry = this.lookup(name, sf);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currentEntry.scope != null && (lookupKind == LookupKind.RECURSIVE || this.currentEntry.scope == this);
                        }

                        @Override
                        public Symbol next() {
                            Entry prevEntry = this.currentEntry;
                            this.currentEntry = this.currentEntry.next(sf);
                            return prevEntry.sym;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        @Override
        public Scope getOrigin(Symbol s) {
            Entry e = this.lookup(s.name);
            while (e.scope != null) {
                if (e.sym == s) {
                    return this;
                }
                e = e.next();
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol s) {
            return false;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Scope[");
            ScopeImpl s = this;
            while (s != null) {
                if (s != this) {
                    result.append(" | ");
                }
                Entry e = s.elems;
                while (e != null) {
                    if (e != s.elems) {
                        result.append(", ");
                    }
                    result.append(e.sym);
                    e = e.sibling;
                }
                s = s.next;
            }
            result.append("]");
            return result.toString();
        }
    }

    public static abstract class WriteableScope
    extends Scope {
        public WriteableScope(Symbol owner) {
            super(owner);
        }

        public abstract void enter(Symbol var1);

        public abstract void enterIfAbsent(Symbol var1);

        public abstract void remove(Symbol var1);

        public final WriteableScope dup() {
            return this.dup(this.owner);
        }

        public abstract WriteableScope dup(Symbol var1);

        public abstract WriteableScope leave();

        public final WriteableScope dupUnshared() {
            return this.dupUnshared(this.owner);
        }

        public abstract WriteableScope dupUnshared(Symbol var1);

        public static WriteableScope create(Symbol owner) {
            return new ScopeImpl(owner);
        }
    }

    public static enum LookupKind {
        RECURSIVE,
        NON_RECURSIVE;

    }

    public static class ScopeListenerList {
        List<WeakReference<ScopeListener>> listeners = List.nil();

        void add(ScopeListener sl) {
            this.listeners = this.listeners.prepend(new WeakReference<ScopeListener>(sl));
        }

        void symbolAdded(Symbol sym, Scope scope) {
            this.walkReferences(sym, scope, false);
        }

        void symbolRemoved(Symbol sym, Scope scope) {
            this.walkReferences(sym, scope, true);
        }

        private void walkReferences(Symbol sym, Scope scope, boolean isRemove) {
            ListBuffer<WeakReference<ScopeListener>> newListeners = new ListBuffer<WeakReference<ScopeListener>>();
            for (WeakReference<ScopeListener> wsl : this.listeners) {
                ScopeListener sl = (ScopeListener)wsl.get();
                if (sl == null) continue;
                if (isRemove) {
                    sl.symbolRemoved(sym, scope);
                } else {
                    sl.symbolAdded(sym, scope);
                }
                newListeners.add(wsl);
            }
            this.listeners = newListeners.toList();
        }
    }

    public static interface ScopeListener {
        public void symbolAdded(Symbol var1, Scope var2);

        public void symbolRemoved(Symbol var1, Scope var2);
    }
}

