/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractPackageIndexWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SectionName;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private DocletEnvironment root;
    private Map<String, SortedSet<PackageElement>> groupPackageMap;
    private List<String> groupList;
    private HtmlTree htmlTree = HtmlTree.MAIN();

    public PackageIndexWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.root = configuration.root;
        this.groupPackageMap = configuration.group.groupPackages(this.packages);
        this.groupList = configuration.group.getGroupList();
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.OVERVIEW_SUMMARY;
        try {
            PackageIndexWriter packgen = new PackageIndexWriter(configuration, filename);
            packgen.buildPackageIndexFile("doclet.Window_Overview_Summary", true);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addIndex(Content body) {
        for (String groupname : this.groupList) {
            SortedSet<PackageElement> list = this.groupPackageMap.get(groupname);
            if (list == null || list.isEmpty()) continue;
            this.addIndexContents(list, groupname, this.configuration.getText("doclet.Member_Table_Summary", groupname, this.configuration.getText("doclet.packages")), body);
        }
    }

    @Override
    protected void addPackagesList(Collection<PackageElement> packages, String text, String tableSummary, Content body) {
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.overviewSummary, this.getTableCaption(new RawHtml(text))) : HtmlTree.TABLE(HtmlStyle.overviewSummary, tableSummary, this.getTableCaption(new RawHtml(text)));
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        this.addPackagesList(packages, tbody);
        ((Content)table).addContent(tbody);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.contentContainer, table);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.htmlTree.addContent(div);
        } else {
            body.addContent(div);
        }
    }

    protected void addPackagesList(Collection<PackageElement> packages, Content tbody) {
        boolean altColor = true;
        for (PackageElement pkg : packages) {
            if (!(pkg.isUnnamed() || this.configuration.nodeprecated && this.utils.isDeprecated(pkg))) {
                Content packageLinkContent = this.getPackageLink(pkg, this.getPackageName(pkg));
                HtmlTree tdPackage = HtmlTree.TD(HtmlStyle.colFirst, packageLinkContent);
                HtmlTree tdSummary = new HtmlTree(HtmlTag.TD);
                tdSummary.addStyle(HtmlStyle.colLast);
                this.addSummaryComment(pkg, tdSummary);
                HtmlTree tr = HtmlTree.TR(tdPackage);
                tr.addContent(tdSummary);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                tbody.addContent(tr);
            }
            altColor = !altColor;
        }
    }

    @Override
    protected void addOverviewHeader(Content body) {
        this.addConfigurationTitle(body);
        if (!this.utils.getBody(this.configuration.overviewElement).isEmpty()) {
            HtmlTree subTitleDiv = new HtmlTree(HtmlTag.DIV);
            subTitleDiv.addStyle(HtmlStyle.subTitle);
            this.addSummaryComment(this.configuration.overviewElement, subTitleDiv);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.header, subTitleDiv);
            Content see = this.seeLabel;
            see.addContent(" ");
            HtmlTree descPara = HtmlTree.P(see);
            Content descLink = this.getHyperLink(this.getDocLink(SectionName.OVERVIEW_DESCRIPTION), this.descriptionLabel, "", "");
            ((Content)descPara).addContent(descLink);
            ((Content)div).addContent(descPara);
            if (this.configuration.allowTag(HtmlTag.MAIN)) {
                this.htmlTree.addContent(div);
            } else {
                body.addContent(div);
            }
        }
    }

    protected void addOverviewComment(Content htmltree) {
        if (!this.utils.getBody(this.configuration.overviewElement).isEmpty()) {
            htmltree.addContent(this.getMarkerAnchor(SectionName.OVERVIEW_DESCRIPTION));
            this.addInlineComment(this.configuration.overviewElement, htmltree);
        }
    }

    @Override
    protected void addOverview(Content body) throws IOException {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        this.addOverviewComment(div);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.htmlTree.addContent(div);
            body.addContent(this.htmlTree);
        } else {
            body.addContent(div);
        }
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : body;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            body.addContent(htmlTree);
        }
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
    }
}

