/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlSerialFieldWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlSerialMethodWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;

public class SerializedFormWriterImpl
extends SubWriterHolderWriter
implements SerializedFormWriter {
    Set<TypeElement> visibleClasses;
    private HtmlTree mainTree = HtmlTree.MAIN();

    public SerializedFormWriterImpl(ConfigurationImpl configuration) throws IOException {
        super(configuration, DocPaths.SERIALIZED_FORM);
        this.visibleClasses = configuration.root.getIncludedClasses();
    }

    @Override
    public Content getHeader(String header) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(header));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        StringContent h1Content = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, h1Content);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    public Content getSerializedSummariesHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getPackageSerializedHeader() {
        HtmlTree htmlTree;
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            htmlTree = HtmlTree.SECTION();
        } else {
            htmlTree = new HtmlTree(HtmlTag.LI);
            htmlTree.addStyle(HtmlStyle.blockList);
        }
        return htmlTree;
    }

    @Override
    public Content getPackageHeader(String packageName) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packageLabel);
        ((Content)heading).addContent(this.getSpace());
        ((Content)heading).addContent(packageName);
        return heading;
    }

    @Override
    public Content getClassSerializedHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public boolean isVisibleClass(TypeElement typeElement) {
        return this.visibleClasses.contains(typeElement) && this.configuration.isGeneratedDoc(typeElement);
    }

    @Override
    public Content getClassHeader(TypeElement typeElement) {
        StringContent classLink = this.isVisibleClass(typeElement) ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, typeElement).label(this.configuration.getClassName(typeElement))) : new StringContent(this.utils.getFullyQualifiedName(typeElement));
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, this.getMarkerAnchor(this.utils.getFullyQualifiedName(typeElement)));
        Content superClassLink = typeElement.getSuperclass() != null ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SERIALIZED_FORM, typeElement.getSuperclass())) : null;
        Content className = superClassLink == null ? this.configuration.getResource("doclet.Class_0_implements_serializable", classLink) : this.configuration.getResource("doclet.Class_0_extends_implements_serializable", classLink, superClassLink);
        ((Content)li).addContent(HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, className));
        return li;
    }

    @Override
    public Content getSerialUIDInfoHeader() {
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        dl.addStyle(HtmlStyle.nameValue);
        return dl;
    }

    @Override
    public void addSerialUIDInfo(String header, String serialUID, Content serialUidTree) {
        StringContent headerContent = new StringContent(header);
        serialUidTree.addContent(HtmlTree.DT(headerContent));
        StringContent serialContent = new StringContent(serialUID);
        serialUidTree.addContent(HtmlTree.DD(serialContent));
    }

    @Override
    public Content getClassContentHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getSerializedContent(Content serializedTreeContent) {
        HtmlTree divContent = HtmlTree.DIV(HtmlStyle.serializedFormContainer, serializedTreeContent);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(divContent);
            return this.mainTree;
        }
        return divContent;
    }

    @Override
    public void addPackageSerializedTree(Content serializedSummariesTree, Content packageSerializedTree) {
        serializedSummariesTree.addContent(this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.LI(HtmlStyle.blockList, packageSerializedTree) : packageSerializedTree);
    }

    @Override
    public void addFooter(Content serializedTree) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : serializedTree;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            serializedTree.addContent(htmlTree);
        }
    }

    @Override
    public void printDocument(Content serializedTree) throws IOException {
        this.printHtmlDocument(null, true, serializedTree);
    }

    @Override
    public SerializedFormWriter.SerialFieldWriter getSerialFieldWriter(TypeElement typeElement) {
        return new HtmlSerialFieldWriter(this, typeElement);
    }

    @Override
    public SerializedFormWriter.SerialMethodWriter getSerialMethodWriter(TypeElement typeElement) {
        return new HtmlSerialMethodWriter(this, typeElement);
    }
}

