/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class TypeElementCatalog {
    private final SortedSet<PackageElement> packageSet;
    private final Map<PackageElement, SortedSet<TypeElement>> allClasses;
    private final Map<PackageElement, SortedSet<TypeElement>> ordinaryClasses;
    private final Map<PackageElement, SortedSet<TypeElement>> exceptions;
    private final Map<PackageElement, SortedSet<TypeElement>> enums;
    private final Map<PackageElement, SortedSet<TypeElement>> annotationTypes;
    private final Map<PackageElement, SortedSet<TypeElement>> errors;
    private final Map<PackageElement, SortedSet<TypeElement>> interfaces;
    private final Configuration configuration;
    private final Utils utils;
    private final Comparator<Element> comparator;

    public TypeElementCatalog(Iterable<TypeElement> typeElements, Configuration config) {
        this(config);
        for (TypeElement typeElement : typeElements) {
            this.addClassDoc(typeElement);
        }
    }

    public TypeElementCatalog(Configuration config) {
        this.configuration = config;
        this.utils = config.utils;
        this.comparator = this.utils.makeGeneralPurposeComparator();
        this.allClasses = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.ordinaryClasses = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.exceptions = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.enums = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.annotationTypes = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.errors = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.interfaces = new HashMap<PackageElement, SortedSet<TypeElement>>();
        this.packageSet = new TreeSet<Element>(this.comparator);
    }

    public final void addClassDoc(TypeElement typeElement) {
        if (typeElement == null) {
            return;
        }
        this.addClass(typeElement, this.allClasses);
        if (this.utils.isOrdinaryClass(typeElement)) {
            this.addClass(typeElement, this.ordinaryClasses);
        } else if (this.utils.isException(typeElement)) {
            this.addClass(typeElement, this.exceptions);
        } else if (this.utils.isEnum(typeElement)) {
            this.addClass(typeElement, this.enums);
        } else if (this.utils.isAnnotationType(typeElement)) {
            this.addClass(typeElement, this.annotationTypes);
        } else if (this.utils.isError(typeElement)) {
            this.addClass(typeElement, this.errors);
        } else if (this.utils.isInterface(typeElement)) {
            this.addClass(typeElement, this.interfaces);
        }
    }

    private void addClass(TypeElement typeElement, Map<PackageElement, SortedSet<TypeElement>> map) {
        PackageElement pkg = this.utils.containingPackage(typeElement);
        if (this.utils.isIncluded(pkg) || this.configuration.nodeprecated && this.utils.isDeprecated(pkg)) {
            return;
        }
        SortedSet<TypeElement> s = map.get(pkg);
        if (s == null) {
            this.packageSet.add(pkg);
            s = new TreeSet<Element>(this.comparator);
        }
        s.add(typeElement);
        map.put(pkg, s);
    }

    private SortedSet<TypeElement> getSet(Map<PackageElement, SortedSet<TypeElement>> m, PackageElement key) {
        SortedSet<TypeElement> s = m.get(key);
        if (s != null) {
            return s;
        }
        return new TreeSet<Element>(this.comparator);
    }

    public SortedSet<TypeElement> allClasses(PackageElement packageElement) {
        return this.utils.isIncluded(packageElement) ? this.utils.getTypeElementsAsSortedSet(this.utils.getEnclosedTypeElements(packageElement)) : this.getSet(this.allClasses, packageElement);
    }

    public SortedSet<TypeElement> allUnnamedClasses() {
        for (PackageElement pkg : this.allClasses.keySet()) {
            if (!pkg.isUnnamed()) continue;
            return this.allClasses.get(pkg);
        }
        return new TreeSet<Element>(this.comparator);
    }

    public SortedSet<PackageElement> packages() {
        return this.packageSet;
    }

    public SortedSet<TypeElement> errors(PackageElement pkg) {
        return this.getSet(this.errors, pkg);
    }

    public SortedSet<TypeElement> exceptions(PackageElement pkg) {
        return this.getSet(this.exceptions, pkg);
    }

    public SortedSet<TypeElement> enums(PackageElement pkg) {
        return this.getSet(this.enums, pkg);
    }

    public SortedSet<TypeElement> annotationTypes(PackageElement pkg) {
        return this.getSet(this.annotationTypes, pkg);
    }

    public SortedSet<TypeElement> interfaces(PackageElement pkg) {
        return this.getSet(this.interfaces, pkg);
    }

    public SortedSet<TypeElement> ordinaryClasses(PackageElement pkg) {
        return this.getSet(this.ordinaryClasses, pkg);
    }
}

