/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.tool;

import javax.tools.JavaFileObject;
import org.openjdk.source.util.TreePath;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javadoc.internal.tool.DocEnv;
import org.openjdk.tools.javadoc.internal.tool.Messager;

public class JavadocEnter
extends Enter {
    final Messager messager;
    final DocEnv docenv;

    public static JavadocEnter instance(Context context) {
        Enter instance = (Enter)context.get(enterKey);
        if (instance == null) {
            instance = new JavadocEnter(context);
        }
        return (JavadocEnter)instance;
    }

    public static void preRegister(Context context) {
        context.put(enterKey, new Context.Factory<Enter>(){

            @Override
            public Enter make(Context c) {
                return new JavadocEnter(c);
            }
        });
    }

    protected JavadocEnter(Context context) {
        super(context);
        this.messager = Messager.instance0(context);
        this.docenv = DocEnv.instance(context);
    }

    @Override
    public void main(List<JCTree.JCCompilationUnit> trees) {
        int nerrors = this.messager.nerrors;
        super.main(trees);
        this.messager.nwarnings += this.messager.nerrors - nerrors;
        this.messager.nerrors = nerrors;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        super.visitTopLevel(tree);
        if (tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE)) {
            JCTree.JCPackageDecl pd = tree.getPackage();
            TreePath tp = pd == null ? this.docenv.getTreePath(tree) : this.docenv.getTreePath(tree, pd);
            this.docenv.setElementToTreePath(tree.packge, tp);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        if (tree.sym == null) {
            return;
        }
        if (tree.sym.kind == Kinds.Kind.TYP || tree.sym.kind == Kinds.Kind.ERR) {
            Symbol.ClassSymbol c = tree.sym;
            this.docenv.setElementToTreePath(c, this.docenv.getTreePath(this.env.toplevel, tree));
        }
    }

    @Override
    protected void duplicateClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
    }
}

