/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.tool;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.Options;

public enum ToolOption {
    BOOTCLASSPATH("-bootclasspath", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.BOOTCLASSPATH, arg);
        }
    }
    ,
    CLASSPATH("-classpath", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.CLASSPATH, arg);
        }
    }
    ,
    CP("-cp", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.CP, arg);
        }
    }
    ,
    EXTDIRS("-extdirs", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.EXTDIRS, arg);
        }
    }
    ,
    SOURCEPATH("-sourcepath", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.SOURCEPATH, arg);
        }
    }
    ,
    SYSCLASSPATH("-sysclasspath", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setFileManagerOpt(Option.BOOTCLASSPATH, arg);
        }
    }
    ,
    ENCODING("-encoding", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.encoding = arg;
            helper.setCompilerOpt(this.opt, arg);
        }
    }
    ,
    RELEASE("-release", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setCompilerOpt(this.opt, arg);
        }
    }
    ,
    SOURCE("-source", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setCompilerOpt(this.opt, arg);
        }
    }
    ,
    XMAXERRS("-Xmaxerrs", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setCompilerOpt(this.opt, arg);
        }
    }
    ,
    XMAXWARNS("-Xmaxwarns", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setCompilerOpt(this.opt, arg);
        }
    }
    ,
    DOCLET("-doclet", true),
    DOCLETPATH("-docletpath", true),
    SUBPACKAGES("-subpackages", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.addToList(helper.subPackages, arg);
        }
    }
    ,
    EXCLUDE("-exclude", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.addToList(helper.excludedPackages, arg);
        }
    }
    ,
    PACKAGE("-package"){

        @Override
        public void process(Helper helper) {
            helper.setFilter("package");
        }
    }
    ,
    PRIVATE("-private"){

        @Override
        public void process(Helper helper) {
            helper.setFilter("private");
        }
    }
    ,
    PROTECTED("-protected"){

        @Override
        public void process(Helper helper) {
            helper.setFilter("protected");
        }
    }
    ,
    PUBLIC("-public"){

        @Override
        public void process(Helper helper) {
            helper.setFilter("public");
        }
    }
    ,
    PROMPT("-prompt"){

        @Override
        public void process(Helper helper) {
            helper.compOpts.put("-prompt", "-prompt");
            helper.promptOnError = true;
        }
    }
    ,
    QUIET("-quiet"){

        @Override
        public void process(Helper helper) {
            helper.quiet = true;
        }
    }
    ,
    VERBOSE("-verbose"){

        @Override
        public void process(Helper helper) {
            helper.compOpts.put("-verbose", "");
        }
    }
    ,
    XWERROR("-Xwerror"){

        @Override
        public void process(Helper helper) {
            helper.rejectWarnings = true;
        }
    }
    ,
    BREAKITERATOR("-breakiterator"){

        @Override
        public void process(Helper helper) {
            helper.breakiterator = true;
        }
    }
    ,
    LOCALE("-locale", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.docLocale = arg;
        }
    }
    ,
    OVERVIEW("-overview", true){

        @Override
        public void process(Helper helper, String arg) {
            helper.setOverviewpath(arg);
        }
    }
    ,
    XCLASSES("-Xclasses"){

        @Override
        public void process(Helper helper) {
            helper.docClasses = true;
        }
    }
    ,
    HELP("-help"){

        @Override
        public void process(Helper helper) {
            helper.usage();
        }
    }
    ,
    X("-X"){

        @Override
        public void process(Helper helper) {
            helper.Xusage();
        }
    };

    public final String opt;
    public final boolean hasArg;

    private ToolOption(String opt) {
        this(opt, false);
    }

    private ToolOption(String opt, boolean hasArg) {
        this.opt = opt;
        this.hasArg = hasArg;
    }

    void process(Helper helper, String arg) {
    }

    void process(Helper helper) {
    }

    static ToolOption get(String name) {
        for (ToolOption o : ToolOption.values()) {
            if (!name.equals(o.opt)) continue;
            return o;
        }
        return null;
    }

    static abstract class Helper {
        final List<List<String>> options = new ArrayList<List<String>>();
        final List<String> subPackages = new ArrayList<String>();
        final List<String> excludedPackages = new ArrayList<String>();
        final Map<Option, String> fileManagerOpts = new LinkedHashMap<Option, String>();
        Options compOpts;
        String encoding = null;
        boolean breakiterator = false;
        boolean quiet = false;
        boolean docClasses = false;
        boolean rejectWarnings = false;
        boolean promptOnError;
        String docLocale = "";
        String showAccess = null;
        String overviewpath;

        Helper() {
        }

        abstract void usage();

        abstract void Xusage();

        abstract void usageError(String var1, Object ... var2);

        void addToList(List<String> list, String str) {
            StringTokenizer st = new StringTokenizer(str, ":");
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                list.add(current);
            }
        }

        void setFilter(String showAccess) {
            if (showAccess != null) {
                if (!("public".equals(showAccess) || "protected".equals(showAccess) || "private".equals(showAccess) || "package".equals(showAccess))) {
                    this.usageError("main.incompatible.access.flags", new Object[0]);
                }
                this.showAccess = showAccess;
            }
        }

        void setCompilerOpt(String opt, String arg) {
            if (this.compOpts.get(opt) != null) {
                this.usageError("main.option.already.seen", opt);
            }
            this.compOpts.put(opt, arg);
        }

        void setFileManagerOpt(Option opt, String arg) {
            this.fileManagerOpts.put(opt, arg);
        }

        private void setOverviewpath(String arg) {
            this.overviewpath = arg;
        }
    }
}

