/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.bookie.BufferedReadChannel;
import org.apache.bookkeeper.util.ZeroBuffer;

public class BufferedChannel
extends BufferedReadChannel {
    protected final int writeCapacity;
    protected AtomicLong writeBufferStartPosition = new AtomicLong(0L);
    protected final ByteBuffer writeBuffer;
    protected volatile long position;

    public BufferedChannel(FileChannel fc, int capacity) throws IOException {
        this(fc, capacity, capacity);
    }

    public BufferedChannel(FileChannel fc, int writeCapacity, int readCapacity) throws IOException {
        super(fc, readCapacity);
        this.readBuffer.limit(readCapacity);
        this.writeCapacity = writeCapacity;
        this.position = fc.position();
        this.writeBufferStartPosition.set(this.position);
        this.writeBuffer = ByteBuffer.allocateDirect(writeCapacity);
    }

    public synchronized void write(ByteBuffer src) throws IOException {
        int copied = 0;
        while (src.remaining() > 0) {
            int truncated = 0;
            if (this.writeBuffer.remaining() < src.remaining()) {
                truncated = src.remaining() - this.writeBuffer.remaining();
                src.limit(src.limit() - truncated);
            }
            copied += src.remaining();
            this.writeBuffer.put(src);
            src.limit(src.limit() + truncated);
            if (this.writeBuffer.remaining() != 0) continue;
            this.flushInternal();
        }
        this.position += (long)copied;
    }

    public long position() {
        return this.position;
    }

    public long getFileChannelPosition() {
        return this.writeBufferStartPosition.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean shouldForceWrite) throws IOException {
        BufferedChannel bufferedChannel = this;
        synchronized (bufferedChannel) {
            this.flushInternal();
        }
        if (shouldForceWrite) {
            this.forceWrite(false);
        }
    }

    private void flushInternal() throws IOException {
        this.writeBuffer.flip();
        do {
            this.fileChannel.write(this.writeBuffer);
        } while (this.writeBuffer.hasRemaining());
        this.writeBuffer.clear();
        this.writeBufferStartPosition.set(this.fileChannel.position());
    }

    public long forceWrite(boolean forceMetadata) throws IOException {
        long positionForceWrite = this.writeBufferStartPosition.get();
        this.fileChannel.force(forceMetadata);
        return positionForceWrite;
    }

    @Override
    public synchronized int read(ByteBuffer dest, long pos) throws IOException {
        long prevPos = pos;
        while (dest.remaining() > 0) {
            ByteBuffer src;
            long bytesToCopy;
            long positionInBuffer;
            if (this.writeBuffer != null && this.writeBufferStartPosition.get() <= pos) {
                positionInBuffer = pos - this.writeBufferStartPosition.get();
                bytesToCopy = (long)this.writeBuffer.position() - positionInBuffer;
                if (bytesToCopy > (long)dest.remaining()) {
                    bytesToCopy = dest.remaining();
                }
                if (bytesToCopy == 0L) {
                    throw new IOException("Read past EOF");
                }
                src = this.writeBuffer.duplicate();
                src.position((int)positionInBuffer);
                src.limit((int)(positionInBuffer + bytesToCopy));
                dest.put(src);
                pos += bytesToCopy;
                continue;
            }
            if (this.writeBuffer == null && this.writeBufferStartPosition.get() <= pos) break;
            if (this.readBufferStartPosition <= pos && pos < this.readBufferStartPosition + (long)this.readBuffer.capacity()) {
                positionInBuffer = pos - this.readBufferStartPosition;
                bytesToCopy = (long)this.readBuffer.capacity() - positionInBuffer;
                if (bytesToCopy > (long)dest.remaining()) {
                    bytesToCopy = dest.remaining();
                }
                src = this.readBuffer.duplicate();
                src.position((int)positionInBuffer);
                src.limit((int)(positionInBuffer + bytesToCopy));
                dest.put(src);
                pos += bytesToCopy;
                continue;
            }
            this.readBufferStartPosition = pos;
            this.readBuffer.clear();
            if (this.readBufferStartPosition + (long)this.readBuffer.capacity() >= this.writeBufferStartPosition.get()) {
                this.readBufferStartPosition = this.writeBufferStartPosition.get() - (long)this.readBuffer.capacity();
                if (this.readBufferStartPosition < 0L) {
                    ZeroBuffer.put(this.readBuffer, (int)(-this.readBufferStartPosition));
                }
            }
            while (this.readBuffer.remaining() > 0) {
                if (this.fileChannel.read(this.readBuffer, this.readBufferStartPosition + (long)this.readBuffer.position()) > 0) continue;
                throw new IOException("Short read");
            }
            ZeroBuffer.put(this.readBuffer);
            this.readBuffer.clear();
        }
        return (int)(pos - prevPos);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.writeBuffer.clear();
    }
}

