/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.base.Charsets;
import bk-shade.com.google.common.base.Joiner;
import bk-shade.com.google.common.collect.Sets;
import bk-shade.com.google.proto_2.6.1.Message;
import bk-shade.com.google.proto_2.6.1.TextFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.ZkVersion;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Cookie {
    private static final Logger LOG = LoggerFactory.getLogger(Cookie.class);
    static final int CURRENT_COOKIE_LAYOUT_VERSION = 4;
    private final int layoutVersion;
    private final String bookieHost;
    private final String journalDirs;
    private final String ledgerDirs;
    private final String instanceId;
    private static final String SEPARATOR = "\t";

    private Cookie(int layoutVersion, String bookieHost, String journalDirs, String ledgerDirs, String instanceId) {
        this.layoutVersion = layoutVersion;
        this.bookieHost = bookieHost;
        this.journalDirs = journalDirs;
        this.ledgerDirs = ledgerDirs;
        this.instanceId = instanceId;
    }

    private static String encodeDirPaths(String[] dirs) {
        StringBuilder b = new StringBuilder();
        b.append(dirs.length);
        for (String d : dirs) {
            b.append(SEPARATOR).append(d);
        }
        return b.toString();
    }

    private static String[] decodeDirPathFromCookie(String s) {
        return s.substring(s.indexOf(SEPARATOR) + SEPARATOR.length()).split(SEPARATOR);
    }

    String[] getLedgerDirPathsFromCookie() {
        return Cookie.decodeDirPathFromCookie(this.ledgerDirs);
    }

    private boolean isSuperSet(String[] superS, String[] subS) {
        HashSet<String> superSet = Sets.newHashSet(superS);
        HashSet<String> subSet = Sets.newHashSet(subS);
        return superSet.containsAll(subSet);
    }

    private boolean verifyLedgerDirs(Cookie c, boolean checkIfSuperSet) {
        if (!checkIfSuperSet) {
            return this.ledgerDirs.equals(c.ledgerDirs);
        }
        return this.isSuperSet(Cookie.decodeDirPathFromCookie(this.ledgerDirs), Cookie.decodeDirPathFromCookie(c.ledgerDirs));
    }

    private void verifyInternal(Cookie c, boolean checkIfSuperSet) throws BookieException.InvalidCookieException {
        if (c.layoutVersion < 3 && c.layoutVersion != this.layoutVersion) {
            String errMsg = "Cookie is of too old version " + c.layoutVersion;
            LOG.error(errMsg);
            throw new BookieException.InvalidCookieException(errMsg);
        }
        if (!(c.layoutVersion >= 3 && c.bookieHost.equals(this.bookieHost) && c.journalDirs.equals(this.journalDirs) && this.verifyLedgerDirs(c, checkIfSuperSet))) {
            String errMsg = "Cookie [" + this + "] is not matching with [" + c + "]";
            throw new BookieException.InvalidCookieException(errMsg);
        }
        if (this.instanceId == null && c.instanceId != null || this.instanceId != null && !this.instanceId.equals(c.instanceId)) {
            String errMsg = "instanceId " + this.instanceId + " is not matching with " + c.instanceId;
            throw new BookieException.InvalidCookieException(errMsg);
        }
    }

    public void verify(Cookie c) throws BookieException.InvalidCookieException {
        this.verifyInternal(c, false);
    }

    public void verifyIsSuperSet(Cookie c) throws BookieException.InvalidCookieException {
        this.verifyInternal(c, true);
    }

    public String toString() {
        if (this.layoutVersion <= 3) {
            return this.toStringVersion3();
        }
        DataFormats.CookieFormat.Builder builder = DataFormats.CookieFormat.newBuilder();
        builder.setBookieHost(this.bookieHost);
        builder.setJournalDir(this.journalDirs);
        builder.setLedgerDirs(this.ledgerDirs);
        if (null != this.instanceId) {
            builder.setInstanceId(this.instanceId);
        }
        StringBuilder b = new StringBuilder();
        b.append(4).append("\n");
        b.append(TextFormat.printToString(builder.build()));
        return b.toString();
    }

    private String toStringVersion3() {
        StringBuilder b = new StringBuilder();
        b.append(4).append("\n").append(this.bookieHost).append("\n").append(this.journalDirs).append("\n").append(this.ledgerDirs).append("\n");
        return b.toString();
    }

    private static Builder parse(BufferedReader reader) throws IOException {
        Builder cBuilder = Cookie.newBuilder();
        int layoutVersion = 0;
        String line = reader.readLine();
        if (null == line) {
            throw new EOFException("Exception in parsing cookie");
        }
        try {
            layoutVersion = Integer.parseInt(line.trim());
            cBuilder.setLayoutVersion(layoutVersion);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid string '" + line.trim() + "', cannot parse cookie.");
        }
        if (layoutVersion == 3) {
            cBuilder.setBookieHost(reader.readLine());
            cBuilder.setJournalDirs(reader.readLine());
            cBuilder.setLedgerDirs(reader.readLine());
        } else if (layoutVersion >= 4) {
            DataFormats.CookieFormat.Builder cfBuilder = DataFormats.CookieFormat.newBuilder();
            TextFormat.merge(reader, (Message.Builder)cfBuilder);
            DataFormats.CookieFormat data = cfBuilder.build();
            cBuilder.setBookieHost(data.getBookieHost());
            cBuilder.setJournalDirs(data.getJournalDir());
            cBuilder.setLedgerDirs(data.getLedgerDirs());
            if (null != data.getInstanceId() && !data.getInstanceId().isEmpty()) {
                cBuilder.setInstanceId(data.getInstanceId());
            }
        }
        return cBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToDirectory(File directory) throws IOException {
        File versionFile = new File(directory, "VERSION");
        FileOutputStream fos = new FileOutputStream(versionFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, Charsets.UTF_8));
            bw.write(this.toString());
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    void writeToZooKeeper(ZooKeeper zk, ServerConfiguration conf, Version version) throws KeeperException, InterruptedException, UnknownHostException {
        List<ACL> zkAcls = ZkUtils.getACLs(conf);
        String bookieCookiePath = conf.getZkLedgersRootPath() + "/" + "cookies";
        String zkPath = Cookie.getZkPath(conf);
        byte[] data = this.toString().getBytes(Charsets.UTF_8);
        if (Version.NEW == version) {
            if (zk.exists(bookieCookiePath, false) == null) {
                try {
                    zk.create(bookieCookiePath, new byte[0], zkAcls, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nne) {
                    LOG.info("More than one bookie tried to create {} at once. Safe to ignore", (Object)bookieCookiePath);
                }
            }
            zk.create(zkPath, data, zkAcls, CreateMode.PERSISTENT);
        } else {
            if (!(version instanceof ZkVersion)) {
                throw new IllegalArgumentException("Invalid version type, expected ZkVersion type");
            }
            zk.setData(zkPath, data, ((ZkVersion)version).getZnodeVersion());
        }
    }

    public void deleteFromZooKeeper(ZooKeeper zk, ServerConfiguration conf, Version version) throws KeeperException, InterruptedException, UnknownHostException {
        BookieSocketAddress address = Bookie.getBookieAddress(conf);
        this.deleteFromZooKeeper(zk, conf, address, version);
    }

    public void deleteFromZooKeeper(ZooKeeper zk, AbstractConfiguration conf, BookieSocketAddress address, Version version) throws KeeperException, InterruptedException, UnknownHostException {
        if (!(version instanceof ZkVersion)) {
            throw new IllegalArgumentException("Invalid version type, expected ZkVersion type");
        }
        String zkPath = Cookie.getZkPath(conf, address);
        zk.delete(zkPath, ((ZkVersion)version).getZnodeVersion());
        LOG.info("Removed cookie from {} for bookie {}.", (Object)conf.getZkLedgersRootPath(), (Object)address);
    }

    static Builder generateCookie(ServerConfiguration conf) throws UnknownHostException {
        Builder builder = Cookie.newBuilder();
        builder.setLayoutVersion(4);
        builder.setBookieHost(Bookie.getBookieAddress(conf).toString());
        builder.setJournalDirs(Joiner.on(',').join(conf.getJournalDirNames()));
        builder.setLedgerDirs(Cookie.encodeDirPaths(conf.getLedgerDirNames()));
        return builder;
    }

    static Versioned<Cookie> readFromZooKeeper(ZooKeeper zk, ServerConfiguration conf) throws KeeperException, InterruptedException, IOException, UnknownHostException {
        return Cookie.readFromZooKeeper(zk, conf, Bookie.getBookieAddress(conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Versioned<Cookie> readFromZooKeeper(ZooKeeper zk, AbstractConfiguration conf, BookieSocketAddress address) throws KeeperException, InterruptedException, IOException, UnknownHostException {
        String zkPath = Cookie.getZkPath(conf, address);
        Stat stat = zk.exists(zkPath, false);
        byte[] data = zk.getData(zkPath, false, stat);
        try (BufferedReader reader = new BufferedReader(new StringReader(new String(data, Charsets.UTF_8)));){
            Builder builder = Cookie.parse(reader);
            Cookie cookie = builder.build();
            ZkVersion version = new ZkVersion(stat.getVersion());
            Versioned<Cookie> versioned = new Versioned<Cookie>(cookie, version);
            return versioned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cookie readFromDirectory(File directory) throws IOException {
        File versionFile = new File(directory, "VERSION");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(versionFile), Charsets.UTF_8));){
            Cookie cookie = Cookie.parse(reader).build();
            return cookie;
        }
    }

    static String getZkPath(ServerConfiguration conf) throws UnknownHostException {
        return Cookie.getZkPath(conf, Bookie.getBookieAddress(conf));
    }

    static String getZkPath(AbstractConfiguration conf, BookieSocketAddress address) {
        String bookieCookiePath = conf.getZkLedgersRootPath() + "/" + "cookies";
        return bookieCookiePath + "/" + address;
    }

    public boolean isBookieHostCreatedFromIp() throws IOException {
        int port;
        String[] parts = this.bookieHost.split(":");
        if (parts.length != 2) {
            throw new IOException(this.bookieHost + " does not have the form host:port");
        }
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(this.bookieHost + " does not have the form host:port");
        }
        InetSocketAddress addr = new InetSocketAddress(parts[0], port);
        return addr.toString().startsWith("/");
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(Cookie oldCookie) {
        return new Builder(oldCookie.layoutVersion, oldCookie.bookieHost, oldCookie.journalDirs, oldCookie.ledgerDirs, oldCookie.instanceId);
    }

    public static class Builder {
        private int layoutVersion = 0;
        private String bookieHost = null;
        private String journalDirs = null;
        private String ledgerDirs = null;
        private String instanceId = null;

        private Builder() {
        }

        private Builder(int layoutVersion, String bookieHost, String journalDirs, String ledgerDirs, String instanceId) {
            this.layoutVersion = layoutVersion;
            this.bookieHost = bookieHost;
            this.journalDirs = journalDirs;
            this.ledgerDirs = ledgerDirs;
            this.instanceId = instanceId;
        }

        public Builder setLayoutVersion(int layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public Builder setBookieHost(String bookieHost) {
            this.bookieHost = bookieHost;
            return this;
        }

        public Builder setJournalDirs(String journalDirs) {
            this.journalDirs = journalDirs;
            return this;
        }

        public Builder setLedgerDirs(String ledgerDirs) {
            this.ledgerDirs = ledgerDirs;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.layoutVersion, this.bookieHost, this.journalDirs, this.ledgerDirs, this.instanceId);
        }
    }
}

