/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntryLogMetadata {
    private final long entryLogId;
    private long totalSize;
    private long remainingSize;
    private ConcurrentHashMap<Long, Long> ledgersMap;

    public EntryLogMetadata(long logId) {
        this.entryLogId = logId;
        this.remainingSize = 0L;
        this.totalSize = 0L;
        this.ledgersMap = new ConcurrentHashMap();
    }

    public void addLedgerSize(long ledgerId, long size) {
        this.totalSize += size;
        this.remainingSize += size;
        Long ledgerSize = this.ledgersMap.get(ledgerId);
        if (null == ledgerSize) {
            ledgerSize = 0L;
        }
        ledgerSize = ledgerSize + size;
        this.ledgersMap.put(ledgerId, ledgerSize);
    }

    public void removeLedger(long ledgerId) {
        Long size = this.ledgersMap.remove(ledgerId);
        if (null == size) {
            return;
        }
        this.remainingSize -= size.longValue();
    }

    public boolean containsLedger(long ledgerId) {
        return this.ledgersMap.containsKey(ledgerId);
    }

    public double getUsage() {
        if (this.totalSize == 0L) {
            return 0.0;
        }
        return (double)this.remainingSize / (double)this.totalSize;
    }

    public boolean isEmpty() {
        return this.ledgersMap.isEmpty();
    }

    public long getEntryLogId() {
        return this.entryLogId;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getRemainingSize() {
        return this.remainingSize;
    }

    Map<Long, Long> getLedgersMap() {
        return this.ledgersMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ totalSize = ").append(this.totalSize).append(", remainingSize = ").append(this.remainingSize).append(", ledgersMap = ").append(this.ledgersMap).append(" }");
        return sb.toString();
    }
}

