/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.base.Stopwatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DaemonThreadFactory;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.ZeroBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Journal
extends BookieCriticalThread
implements CheckpointSource {
    private static final Logger LOG = LoggerFactory.getLogger(Journal.class);
    static final int PADDING_MASK = -256;
    static final long MB = 0x100000L;
    static final int KB = 1024;
    final long maxJournalSize;
    final long journalPreAllocSize;
    final int journalWriteBufferSize;
    final int maxBackupJournals;
    final File journalDirectory;
    final ServerConfiguration conf;
    final ForceWriteThread forceWriteThread;
    private final long maxGroupWaitInNanos;
    private final long bufferedEntriesThreshold;
    private final long bufferedWritesThreshold;
    private final boolean flushWhenQueueEmpty;
    private final boolean removePagesFromCache;
    private final LastLogMark lastLogMark = new LastLogMark(0L, 0L);
    private final ExecutorService cbThreadPool;
    final LinkedBlockingQueue<QueueEntry> queue = new LinkedBlockingQueue();
    final LinkedBlockingQueue<ForceWriteRequest> forceWriteRequests = new LinkedBlockingQueue();
    volatile boolean running = true;
    private final LedgerDirsManager ledgerDirsManager;
    private final OpStatsLogger journalAddEntryStats;
    private final OpStatsLogger journalSyncStats;
    private final OpStatsLogger journalCreationStats;
    private final OpStatsLogger journalFlushStats;
    private final OpStatsLogger journalProcessTimeStats;
    private final OpStatsLogger journalQueueStats;
    private final OpStatsLogger forceWriteGroupingCountStats;
    private final OpStatsLogger forceWriteBatchEntriesStats;
    private final OpStatsLogger forceWriteBatchBytesStats;
    private final Counter journalQueueSize;
    private final Counter forceWriteQueueSize;
    private final Counter flushMaxWaitCounter;
    private final Counter flushMaxOutstandingBytesCounter;
    private final Counter flushEmptyQueueCounter;
    private final Counter journalWriteBytes;

    private static List<Long> listJournalIds(File journalDir, JournalIdFilter filter) {
        File[] logFiles = journalDir.listFiles();
        if (logFiles == null || logFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> logs = new ArrayList<Long>();
        for (File f : logFiles) {
            String name = f.getName();
            if (!name.endsWith(".txn")) continue;
            String idString = name.split("\\.")[0];
            long id = Long.parseLong(idString, 16);
            if (filter != null) {
                if (!filter.accept(id)) continue;
                logs.add(id);
                continue;
            }
            logs.add(id);
        }
        Collections.sort(logs);
        return logs;
    }

    static void writePaddingBytes(JournalChannel jc, ByteBuffer paddingBuffer, int journalAlignSize) throws IOException {
        int bytesToAlign = (int)(jc.bc.position() % (long)journalAlignSize);
        if (0 != bytesToAlign) {
            int paddingBytes = journalAlignSize - bytesToAlign;
            paddingBytes = paddingBytes < 8 ? journalAlignSize - (8 - paddingBytes) : (paddingBytes -= 8);
            paddingBuffer.clear();
            paddingBuffer.putInt(-256);
            paddingBuffer.putInt(paddingBytes);
            paddingBuffer.position(8 + paddingBytes);
            paddingBuffer.flip();
            jc.preAllocIfNeeded(paddingBuffer.limit());
            jc.bc.write(paddingBuffer);
        }
    }

    public Journal(File journalDirectory, ServerConfiguration conf, LedgerDirsManager ledgerDirsManager) {
        this(journalDirectory, conf, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public Journal(File journalDirectory, ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger) {
        super("BookieJournal-" + conf.getBookiePort());
        this.ledgerDirsManager = ledgerDirsManager;
        this.conf = conf;
        this.journalDirectory = journalDirectory;
        this.maxJournalSize = conf.getMaxJournalSizeMB() * 0x100000L;
        this.journalPreAllocSize = (long)conf.getJournalPreAllocSizeMB() * 0x100000L;
        this.journalWriteBufferSize = conf.getJournalWriteBufferSizeKB() * 1024;
        this.maxBackupJournals = conf.getMaxBackupJournals();
        this.forceWriteThread = new ForceWriteThread(this, conf.getJournalAdaptiveGroupWrites());
        this.maxGroupWaitInNanos = TimeUnit.MILLISECONDS.toNanos(conf.getJournalMaxGroupWaitMSec());
        this.bufferedWritesThreshold = conf.getJournalBufferedWritesThreshold();
        this.bufferedEntriesThreshold = conf.getJournalBufferedEntriesThreshold();
        this.cbThreadPool = Executors.newFixedThreadPool(conf.getNumJournalCallbackThreads(), new DaemonThreadFactory());
        this.flushWhenQueueEmpty = this.maxGroupWaitInNanos <= 0L || conf.getJournalFlushWhenQueueEmpty();
        this.removePagesFromCache = conf.getJournalRemovePagesFromCache();
        this.lastLogMark.readLog();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Last Log Mark : {}", (Object)this.lastLogMark.getCurMark());
        }
        this.journalAddEntryStats = statsLogger.getOpStatsLogger("JOURNAL_ADD_ENTRY");
        this.journalSyncStats = statsLogger.getOpStatsLogger("JOURNAL_SYNC");
        this.journalCreationStats = statsLogger.getOpStatsLogger("JOURNAL_CREATION_LATENCY");
        this.journalFlushStats = statsLogger.getOpStatsLogger("JOURNAL_FLUSH_LATENCY");
        this.journalQueueStats = statsLogger.getOpStatsLogger("JOURNAL_QUEUE_LATENCY");
        this.journalProcessTimeStats = statsLogger.getOpStatsLogger("JOURNAL_PROCESS_TIME_LATENCY");
        this.forceWriteGroupingCountStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_GROUPING_COUNT");
        this.forceWriteBatchEntriesStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_BATCH_ENTRIES");
        this.forceWriteBatchBytesStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_BATCH_BYTES");
        this.journalQueueSize = statsLogger.getCounter("JOURNAL_QUEUE_SIZE");
        this.forceWriteQueueSize = statsLogger.getCounter("JOURNAL_FORCE_WRITE_QUEUE_SIZE");
        this.flushMaxWaitCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_MAX_WAIT");
        this.flushMaxOutstandingBytesCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_MAX_OUTSTANDING_BYTES");
        this.flushEmptyQueueCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_EMPTY_QUEUE");
        this.journalWriteBytes = statsLogger.getCounter("JOURNAL_WRITE_BYTES");
    }

    public File getJournalDirectory() {
        return this.journalDirectory;
    }

    LastLogMark getLastLogMark() {
        return this.lastLogMark;
    }

    @Override
    public CheckpointSource.Checkpoint newCheckpoint() {
        return new LogMarkCheckpoint(this.lastLogMark.markLog());
    }

    @Override
    public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        List<Long> logs;
        if (!(checkpoint instanceof LogMarkCheckpoint)) {
            return;
        }
        LogMarkCheckpoint lmcheckpoint = (LogMarkCheckpoint)checkpoint;
        LastLogMark mark = lmcheckpoint.mark;
        mark.rollLog(mark);
        if (compact && (logs = Journal.listJournalIds(this.journalDirectory, new JournalRollingFilter(mark))).size() >= this.maxBackupJournals) {
            int maxIdx = logs.size() - this.maxBackupJournals;
            for (int i = 0; i < maxIdx; ++i) {
                long id = logs.get(i);
                if (id >= mark.getCurMark().getLogFileId()) continue;
                File journalFile = new File(this.journalDirectory, Long.toHexString(id) + ".txn");
                if (!journalFile.delete()) {
                    LOG.warn("Could not delete old journal file {}", (Object)journalFile);
                }
                LOG.info("garbage collected journal " + journalFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanJournal(long journalId, long journalPos, JournalScanner scanner) throws IOException {
        JournalChannel recLog = journalPos <= 0L ? new JournalChannel(this.journalDirectory, journalId, this.journalPreAllocSize, this.journalWriteBufferSize) : new JournalChannel(this.journalDirectory, journalId, this.journalPreAllocSize, this.journalWriteBufferSize, journalPos);
        int journalVersion = recLog.getFormatVersion();
        try {
            ByteBuffer lenBuff = ByteBuffer.allocate(4);
            ByteBuffer recBuff = ByteBuffer.allocate(65536);
            while (true) {
                long offset = recLog.fc.position();
                lenBuff.clear();
                Journal.fullRead(recLog, lenBuff);
                if (lenBuff.remaining() != 0) {
                    break;
                }
                lenBuff.flip();
                int len = lenBuff.getInt();
                if (len == 0) {
                    break;
                }
                boolean isPaddingRecord = false;
                if (len == -256) {
                    if (journalVersion >= 5) {
                        lenBuff.clear();
                        Journal.fullRead(recLog, lenBuff);
                        if (lenBuff.remaining() != 0) {
                            break;
                        }
                        lenBuff.flip();
                        len = lenBuff.getInt();
                        if (len == 0) continue;
                        isPaddingRecord = true;
                    } else {
                        throw new IOException("Invalid record found with negative length : " + len);
                    }
                }
                recBuff.clear();
                if (recBuff.remaining() < len) {
                    recBuff = ByteBuffer.allocate(len);
                }
                recBuff.limit(len);
                if (Journal.fullRead(recLog, recBuff) != len) {
                    break;
                }
                recBuff.flip();
                if (isPaddingRecord) continue;
                scanner.process(journalVersion, offset, recBuff);
            }
        }
        finally {
            recLog.close();
        }
    }

    public void replay(JournalScanner scanner) throws IOException {
        final LogMark markedLog = this.lastLogMark.getCurMark();
        List<Long> logs = Journal.listJournalIds(this.journalDirectory, new JournalIdFilter(){

            @Override
            public boolean accept(long journalId) {
                return journalId >= markedLog.getLogFileId();
            }
        });
        if (markedLog.getLogFileId() > 0L && (logs.size() == 0 || logs.get(0).longValue() != markedLog.getLogFileId())) {
            throw new IOException("Recovery log " + markedLog.getLogFileId() + " is missing");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to relay journal logs : {}", logs);
        }
        for (Long id : logs) {
            long logPosition = 0L;
            if (id.longValue() == markedLog.getLogFileId()) {
                logPosition = markedLog.getLogFileOffset();
            }
            LOG.info("Replaying journal {} from position {}", (Object)id, (Object)logPosition);
            this.scanJournal(id, logPosition, scanner);
        }
    }

    public void logAddEntry(ByteBuffer entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) {
        this.logAddEntry(Unpooled.wrappedBuffer((ByteBuffer)entry), cb, ctx);
    }

    public void logAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        this.journalQueueSize.inc();
        entry.retain();
        this.queue.add(new QueueEntry(entry, ledgerId, entryId, cb, ctx, MathUtils.nowInNano()));
    }

    public int getJournalQueueLength() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        LOG.info("Starting journal on {}", (Object)this.journalDirectory);
        LinkedList<QueueEntry> toFlush = new LinkedList<QueueEntry>();
        ByteBuffer lenBuff = ByteBuffer.allocate(4);
        ByteBuffer paddingBuff = ByteBuffer.allocate(2 * this.conf.getJournalAlignmentSize());
        ZeroBuffer.put(paddingBuff);
        int journalFormatVersionToWrite = this.conf.getJournalFormatVersionToWrite();
        int journalAlignmentSize = this.conf.getJournalAlignmentSize();
        JournalChannel logFile = null;
        this.forceWriteThread.start();
        Stopwatch journalCreationWatcher = Stopwatch.createUnstarted();
        Stopwatch journalFlushWatcher = Stopwatch.createUnstarted();
        long batchSize = 0L;
        try {
            List<Long> journalIds = Journal.listJournalIds(this.journalDirectory, null);
            long logId = journalIds.isEmpty() ? System.currentTimeMillis() : journalIds.get(journalIds.size() - 1);
            BufferedChannel bc = null;
            long lastFlushPosition = 0L;
            boolean groupWhenTimeout = false;
            long dequeueStartTime = 0L;
            QueueEntry qe = null;
            while (true) {
                if (null == logFile) {
                    journalCreationWatcher.reset().start();
                    logFile = new JournalChannel(this.journalDirectory, ++logId, this.journalPreAllocSize, this.journalWriteBufferSize, journalAlignmentSize, this.removePagesFromCache, journalFormatVersionToWrite);
                    this.journalCreationStats.registerSuccessfulEvent(journalCreationWatcher.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    bc = logFile.getBufferedChannel();
                    lastFlushPosition = bc.position();
                }
                if (qe == null) {
                    if (dequeueStartTime != 0L) {
                        this.journalProcessTimeStats.registerSuccessfulEvent(MathUtils.elapsedNanos(dequeueStartTime), TimeUnit.NANOSECONDS);
                    }
                    if (toFlush.isEmpty()) {
                        qe = this.queue.take();
                        dequeueStartTime = MathUtils.nowInNano();
                        this.journalQueueStats.registerSuccessfulEvent(MathUtils.elapsedNanos(qe.enqueueTime), TimeUnit.NANOSECONDS);
                    } else {
                        long pollWaitTimeNanos = this.maxGroupWaitInNanos - MathUtils.elapsedNanos(((QueueEntry)toFlush.get((int)0)).enqueueTime);
                        if (this.flushWhenQueueEmpty || pollWaitTimeNanos < 0L) {
                            pollWaitTimeNanos = 0L;
                        }
                        qe = this.queue.poll(pollWaitTimeNanos, TimeUnit.NANOSECONDS);
                        dequeueStartTime = MathUtils.nowInNano();
                        if (qe != null) {
                            this.journalQueueStats.registerSuccessfulEvent(MathUtils.elapsedNanos(qe.enqueueTime), TimeUnit.NANOSECONDS);
                        }
                        boolean shouldFlush = false;
                        if (this.maxGroupWaitInNanos > 0L && !groupWhenTimeout && MathUtils.elapsedNanos(((QueueEntry)toFlush.get((int)0)).enqueueTime) > this.maxGroupWaitInNanos) {
                            groupWhenTimeout = true;
                        } else if (this.maxGroupWaitInNanos > 0L && groupWhenTimeout && qe != null && MathUtils.elapsedNanos(qe.enqueueTime) < this.maxGroupWaitInNanos) {
                            groupWhenTimeout = false;
                            shouldFlush = true;
                            this.flushMaxWaitCounter.inc();
                        } else if (qe != null && (this.bufferedEntriesThreshold > 0L && (long)toFlush.size() > this.bufferedEntriesThreshold || bc.position() > lastFlushPosition + this.bufferedWritesThreshold)) {
                            shouldFlush = true;
                            this.flushMaxOutstandingBytesCounter.inc();
                        } else if (qe == null) {
                            shouldFlush = true;
                            this.flushEmptyQueueCounter.inc();
                        }
                        if (shouldFlush) {
                            if (journalFormatVersionToWrite >= 5) {
                                Journal.writePaddingBytes(logFile, paddingBuff, journalAlignmentSize);
                            }
                            journalFlushWatcher.reset().start();
                            bc.flush(false);
                            lastFlushPosition = bc.position();
                            this.journalFlushStats.registerSuccessfulEvent(journalFlushWatcher.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                            if (LOG.isDebugEnabled()) {
                                for (QueueEntry e : toFlush) {
                                    LOG.debug("Written and queuing for flush Ledger:" + e.ledgerId + " Entry:" + e.entryId);
                                }
                            }
                            this.forceWriteBatchEntriesStats.registerSuccessfulValue((long)toFlush.size());
                            this.forceWriteBatchBytesStats.registerSuccessfulValue(batchSize);
                            this.forceWriteRequests.put(new ForceWriteRequest(logFile, logId, lastFlushPosition, toFlush, lastFlushPosition > this.maxJournalSize, false));
                            toFlush = new LinkedList();
                            batchSize = 0L;
                            if (bc.position() > this.maxJournalSize) {
                                logFile = null;
                                continue;
                            }
                        }
                    }
                }
                if (!this.running) break;
                if (qe == null) continue;
                this.journalWriteBytes.add((long)qe.entry.readableBytes());
                this.journalQueueSize.dec();
                batchSize += (long)(4 + qe.entry.readableBytes());
                lenBuff.clear();
                lenBuff.putInt(qe.entry.readableBytes());
                lenBuff.flip();
                logFile.preAllocIfNeeded(4 + qe.entry.readableBytes());
                bc.write(lenBuff);
                bc.write(qe.entry.nioBuffer());
                qe.entry.release();
                toFlush.add(qe);
                qe = null;
            }
            LOG.info("Journal Manager is asked to shut down, quit.");
            logFile.close();
            logFile = null;
        }
        catch (IOException ioe) {
            LOG.error("I/O exception in Journal thread!", (Throwable)ioe);
            IOUtils.close(LOG, logFile);
        }
        catch (InterruptedException ie) {
            LOG.warn("Journal exits when shutting down", (Throwable)ie);
            {
                catch (Throwable throwable) {
                    IOUtils.close(LOG, logFile);
                    throw throwable;
                }
            }
            IOUtils.close(LOG, logFile);
        }
        IOUtils.close(LOG, logFile);
        LOG.info("Journal exited loop!");
    }

    public synchronized void shutdown() {
        try {
            if (!this.running) {
                return;
            }
            LOG.info("Shutting down Journal");
            this.forceWriteThread.shutdown();
            this.cbThreadPool.shutdown();
            if (!this.cbThreadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warn("Couldn't shutdown journal callback thread gracefully. Forcing");
            }
            this.cbThreadPool.shutdownNow();
            this.running = false;
            this.interrupt();
            this.join();
            LOG.info("Finished Shutting down Journal thread");
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted during shutting down journal : ", (Throwable)ie);
        }
    }

    private static int fullRead(JournalChannel fc, ByteBuffer bb) throws IOException {
        int total = 0;
        while (bb.remaining() > 0) {
            int rc = fc.read(bb);
            if (rc <= 0) {
                return total;
            }
            total += rc;
        }
        return total;
    }

    private class ForceWriteThread
    extends BookieCriticalThread {
        volatile boolean running;
        Thread threadToNotifyOnEx;
        private final boolean enableGroupForceWrites;

        public ForceWriteThread(Thread threadToNotifyOnEx, boolean enableGroupForceWrites) {
            super("ForceWriteThread");
            this.running = true;
            this.threadToNotifyOnEx = threadToNotifyOnEx;
            this.enableGroupForceWrites = enableGroupForceWrites;
        }

        @Override
        public void run() {
            LOG.info("ForceWrite Thread started");
            boolean shouldForceWrite = true;
            int numReqInLastForceWrite = 0;
            while (this.running) {
                ForceWriteRequest req = null;
                try {
                    req = Journal.this.forceWriteRequests.take();
                    if (!req.isMarker) {
                        if (shouldForceWrite) {
                            if (this.enableGroupForceWrites) {
                                Journal.this.forceWriteRequests.put(new ForceWriteRequest(req.logFile, 0L, 0L, null, false, true));
                            }
                            if (numReqInLastForceWrite > 0) {
                                Journal.this.forceWriteGroupingCountStats.registerSuccessfulValue((long)numReqInLastForceWrite);
                                numReqInLastForceWrite = 0;
                            }
                        }
                        numReqInLastForceWrite += req.process(shouldForceWrite);
                    }
                    if (this.enableGroupForceWrites && !req.isMarker && !req.shouldClose) {
                        shouldForceWrite = false;
                        continue;
                    }
                    shouldForceWrite = true;
                }
                catch (IOException ioe) {
                    LOG.error("I/O exception in ForceWrite thread", (Throwable)ioe);
                    this.running = false;
                }
                catch (InterruptedException e) {
                    LOG.error("ForceWrite thread interrupted", (Throwable)e);
                    if (null != req) {
                        req.shouldClose = true;
                        req.closeFileIfNecessary();
                    }
                    this.running = false;
                }
            }
            this.threadToNotifyOnEx.interrupt();
        }

        void shutdown() throws InterruptedException {
            this.running = false;
            this.interrupt();
            this.join();
        }
    }

    private class ForceWriteRequest {
        private final JournalChannel logFile;
        private final LinkedList<QueueEntry> forceWriteWaiters;
        private boolean shouldClose;
        private final boolean isMarker;
        private final long lastFlushedPosition;
        private final long logId;

        private ForceWriteRequest(JournalChannel logFile, long logId, long lastFlushedPosition, LinkedList<QueueEntry> forceWriteWaiters, boolean shouldClose, boolean isMarker) {
            this.forceWriteWaiters = forceWriteWaiters;
            this.logFile = logFile;
            this.logId = logId;
            this.lastFlushedPosition = lastFlushedPosition;
            this.shouldClose = shouldClose;
            this.isMarker = isMarker;
            Journal.this.forceWriteQueueSize.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int process(boolean shouldForceWrite) throws IOException {
            Journal.this.forceWriteQueueSize.dec();
            if (this.isMarker) {
                return 0;
            }
            try {
                if (shouldForceWrite) {
                    long startTime = MathUtils.nowInNano();
                    this.logFile.forceWrite(false);
                    Journal.this.journalSyncStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTime), TimeUnit.NANOSECONDS);
                }
                Journal.this.lastLogMark.setCurLogMark(this.logId, this.lastFlushedPosition);
                for (QueueEntry e : this.forceWriteWaiters) {
                    Journal.this.cbThreadPool.execute(e);
                }
                int n = this.forceWriteWaiters.size();
                return n;
            }
            finally {
                this.closeFileIfNecessary();
            }
        }

        public void closeFileIfNecessary() {
            if (this.shouldClose) {
                try {
                    this.logFile.close();
                    this.shouldClose = false;
                }
                catch (IOException ioe) {
                    LOG.error("I/O exception while closing file", (Throwable)ioe);
                }
            }
        }
    }

    private class QueueEntry
    implements Runnable {
        ByteBuf entry;
        long ledgerId;
        long entryId;
        BookkeeperInternalCallbacks.WriteCallback cb;
        Object ctx;
        long enqueueTime;

        QueueEntry(ByteBuf entry, long ledgerId, long entryId, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, long enqueueTime) {
            this.entry = entry.duplicate();
            this.cb = cb;
            this.ctx = ctx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.enqueueTime = enqueueTime;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acknowledge Ledger: {}, Entry: {}", (Object)this.ledgerId, (Object)this.entryId);
            }
            Journal.this.journalAddEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos(this.enqueueTime), TimeUnit.NANOSECONDS);
            this.cb.writeComplete(0, this.ledgerId, this.entryId, null, this.ctx);
        }
    }

    public static interface JournalScanner {
        public void process(int var1, long var2, ByteBuffer var4) throws IOException;
    }

    private static class JournalRollingFilter
    implements JournalIdFilter {
        final LastLogMark lastMark;

        JournalRollingFilter(LastLogMark lastMark) {
            this.lastMark = lastMark;
        }

        @Override
        public boolean accept(long journalId) {
            return journalId < this.lastMark.getCurMark().getLogFileId();
        }
    }

    class LastLogMark {
        private final LogMark curMark;

        LastLogMark(long logId, long logPosition) {
            this.curMark = new LogMark(logId, logPosition);
        }

        void setCurLogMark(long logId, long logPosition) {
            this.curMark.setLogMark(logId, logPosition);
        }

        LastLogMark markLog() {
            return new LastLogMark(this.curMark.getLogFileId(), this.curMark.getLogFileOffset());
        }

        LogMark getCurMark() {
            return this.curMark;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rollLog(LastLogMark lastMark) throws LedgerDirsManager.NoWritableLedgerDirException {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            lastMark.getCurMark().writeLogMark(bb);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RollLog to persist last marked log : {}", (Object)lastMark.getCurMark());
            }
            List<File> writableLedgerDirs = Journal.this.ledgerDirsManager.getWritableLedgerDirs();
            for (File dir : writableLedgerDirs) {
                File file = new File(dir, "lastMark");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    fos.write(buff);
                    fos.getChannel().force(true);
                    fos.close();
                    fos = null;
                }
                catch (IOException e) {
                    try {
                        LOG.error("Problems writing to " + file, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(LOG, fos);
                        throw throwable;
                    }
                    IOUtils.close(LOG, fos);
                    continue;
                }
                IOUtils.close(LOG, fos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readLog() {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            LogMark mark = new LogMark();
            for (File dir : Journal.this.ledgerDirsManager.getAllLedgerDirs()) {
                File file = new File(dir, "lastMark");
                try {
                    try (FileInputStream fis = new FileInputStream(file);){
                        int bytesRead = fis.read(buff);
                        if (bytesRead != 16) {
                            throw new IOException("Couldn't read enough bytes from lastMark. Wanted 16, got " + bytesRead);
                        }
                    }
                    bb.clear();
                    mark.readLogMark(bb);
                    if (this.curMark.compare(mark) >= 0) continue;
                    this.curMark.setLogMark(mark.getLogFileId(), mark.getLogFileOffset());
                }
                catch (IOException e) {
                    LOG.error("Problems reading from " + file + " (this is okay if it is the first time starting this bookie");
                }
            }
        }

        public String toString() {
            return this.curMark.toString();
        }
    }

    private static class LogMarkCheckpoint
    implements CheckpointSource.Checkpoint {
        final LastLogMark mark;

        public LogMarkCheckpoint(LastLogMark checkpoint) {
            this.mark = checkpoint;
        }

        @Override
        public int compareTo(CheckpointSource.Checkpoint o) {
            if (o == CheckpointSource.Checkpoint.MAX) {
                return -1;
            }
            if (o == CheckpointSource.Checkpoint.MIN) {
                return 1;
            }
            return this.mark.getCurMark().compare(((LogMarkCheckpoint)o).mark.getCurMark());
        }

        public boolean equals(Object o) {
            if (!(o instanceof LogMarkCheckpoint)) {
                return false;
            }
            return 0 == this.compareTo((LogMarkCheckpoint)o);
        }

        public int hashCode() {
            return this.mark.hashCode();
        }

        public String toString() {
            return this.mark.toString();
        }
    }

    private static interface JournalIdFilter {
        public boolean accept(long var1);
    }
}

