/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.util.zip.CRC32;
import org.apache.bookkeeper.client.DigestManager;

class CRC32DigestManager
extends DigestManager {
    private final ThreadLocal<CRC32> crc = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public CRC32DigestManager(long ledgerId) {
        super(ledgerId);
    }

    @Override
    int getMacCodeLength() {
        return 8;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        buf.writeLong(this.crc.get().getValue());
        this.crc.get().reset();
    }

    @Override
    void update(ByteBuf data) {
        this.crc.get().update(data.nioBuffer());
    }
}

