/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractHierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LongHierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(LongHierarchicalLedgerManager.class);
    static final String IDGEN_ZNODE = "idgen-long";
    private static final String MAX_ID_SUFFIX = "9999";
    private static final String MIN_ID_SUFFIX = "0000";

    public LongHierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
    }

    @Override
    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToLongHierarchicalLedgerId(hierarchicalPath);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getLongHierarchicalLedgerPath(ledgerId);
    }

    private long getStartLedgerIdByLevel(String level0, String level1, String level2, String level3) throws IOException {
        return this.getLedgerId(level0, level1, level2, level3, MIN_ID_SUFFIX);
    }

    private long getEndLedgerIdByLevel(String level0, String level1, String level2, String level3) throws IOException {
        return this.getLedgerId(level0, level1, level2, level3, MAX_ID_SUFFIX);
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new RecursiveProcessor(0, this.ledgerRootPath, processor, context, successRc, failureRc), finalCb, context, successRc, failureRc);
    }

    protected static boolean isSpecialZnode(String znode) {
        return LegacyHierarchicalLedgerManager.isSpecialZnode(znode) || znode.length() < 3;
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        return new LongHierarchicalLedgerRangeIterator();
    }

    private class LongHierarchicalLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        private List<Iterator<String>> levelNodesIter = new ArrayList<Iterator>(Collections.nCopies(4, null));
        private List<String> curLevelNodes = new ArrayList<String>(Collections.nCopies(4, null));
        private boolean initialized = false;
        private boolean iteratorDone = false;
        private LedgerManager.LedgerRange nextRange = null;

        private LongHierarchicalLedgerRangeIterator() {
        }

        private synchronized void initialize(String path, int level) throws KeeperException, InterruptedException, IOException {
            String curLNode;
            List levelNodes = LongHierarchicalLedgerManager.this.zk.getChildren(path, null);
            Collections.sort(levelNodes);
            if (level == 0) {
                Iterator l0NodesIter = levelNodes.iterator();
                this.levelNodesIter.set(0, l0NodesIter);
                while (l0NodesIter.hasNext()) {
                    String curL0Node = (String)l0NodesIter.next();
                    if (LongHierarchicalLedgerManager.isSpecialZnode(curL0Node)) continue;
                    this.curLevelNodes.set(0, curL0Node);
                    break;
                }
            } else {
                Iterator lNodesIter = levelNodes.iterator();
                this.levelNodesIter.set(level, lNodesIter);
                if (lNodesIter.hasNext()) {
                    String curLNode2 = (String)lNodesIter.next();
                    this.curLevelNodes.set(level, curLNode2);
                }
            }
            if ((curLNode = this.curLevelNodes.get(level)) != null) {
                if (level != 3) {
                    String nextLevelPath = path + "/" + curLNode;
                    this.initialize(nextLevelPath, level + 1);
                } else {
                    this.nextRange = this.getLedgerRangeByLevel(this.curLevelNodes);
                    this.initialized = true;
                }
            } else {
                this.iteratorDone = true;
            }
        }

        private void clearHigherLevels(int level) {
            for (int i = level + 1; i < 4; ++i) {
                this.curLevelNodes.set(i, null);
            }
        }

        private synchronized boolean moveToNext(int level) throws KeeperException, InterruptedException {
            Iterator<String> curLevelNodesIter = this.levelNodesIter.get(level);
            boolean movedToNextNode = false;
            if (level == 0) {
                while (curLevelNodesIter.hasNext()) {
                    String nextNode = curLevelNodesIter.next();
                    if (LongHierarchicalLedgerManager.isSpecialZnode(nextNode)) continue;
                    this.curLevelNodes.set(level, nextNode);
                    this.clearHigherLevels(level);
                    movedToNextNode = true;
                    break;
                }
            } else if (curLevelNodesIter.hasNext()) {
                String nextNode = curLevelNodesIter.next();
                this.curLevelNodes.set(level, nextNode);
                this.clearHigherLevels(level);
                movedToNextNode = true;
            } else {
                movedToNextNode = this.moveToNext(level - 1);
                if (movedToNextNode) {
                    StringBuilder path = new StringBuilder(LongHierarchicalLedgerManager.this.ledgerRootPath);
                    for (int i = 0; i < level; ++i) {
                        path = path.append("/").append(this.curLevelNodes.get(i));
                    }
                    List newCurLevelNodesList = LongHierarchicalLedgerManager.this.zk.getChildren(path.toString(), null);
                    Collections.sort(newCurLevelNodesList);
                    Iterator newCurLevelNodesIter = newCurLevelNodesList.iterator();
                    this.levelNodesIter.set(level, newCurLevelNodesIter);
                    if (newCurLevelNodesIter.hasNext()) {
                        this.curLevelNodes.set(level, (String)newCurLevelNodesIter.next());
                        this.clearHigherLevels(level);
                        movedToNextNode = true;
                    }
                }
            }
            return movedToNextNode;
        }

        private synchronized void preload() throws IOException, KeeperException, InterruptedException {
            if (!this.iteratorDone && !this.initialized) {
                this.initialize(LongHierarchicalLedgerManager.this.ledgerRootPath, 0);
            }
            while (!(this.nextRange != null && this.nextRange.size() != 0 || this.iteratorDone)) {
                boolean movedToNextNode = this.moveToNext(3);
                if (movedToNextNode) {
                    this.nextRange = this.getLedgerRangeByLevel(this.curLevelNodes);
                    continue;
                }
                this.iteratorDone = true;
            }
        }

        @Override
        public synchronized boolean hasNext() throws IOException {
            try {
                this.preload();
            }
            catch (KeeperException ke) {
                throw new IOException("Error preloading next range", ke);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while preloading", ie);
            }
            return this.nextRange != null && !this.iteratorDone;
        }

        @Override
        public synchronized LedgerManager.LedgerRange next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LedgerManager.LedgerRange r = this.nextRange;
            this.nextRange = null;
            return r;
        }

        private LedgerManager.LedgerRange getLedgerRangeByLevel(List<String> curLevelNodes) throws IOException {
            String level0 = curLevelNodes.get(0);
            String level1 = curLevelNodes.get(1);
            String level2 = curLevelNodes.get(2);
            String level3 = curLevelNodes.get(3);
            StringBuilder nodeBuilder = new StringBuilder();
            nodeBuilder.append(LongHierarchicalLedgerManager.this.ledgerRootPath).append("/").append(level0).append("/").append(level1).append("/").append(level2).append("/").append(level3);
            String nodePath = nodeBuilder.toString();
            List<String> ledgerNodes = null;
            try {
                ledgerNodes = ZkUtils.getChildrenInSingleNode(LongHierarchicalLedgerManager.this.zk, nodePath);
            }
            catch (InterruptedException e) {
                throw new IOException("Error when get child nodes from zk", e);
            }
            NavigableSet<Long> zkActiveLedgers = LongHierarchicalLedgerManager.this.ledgerListToSet(ledgerNodes, nodePath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("All active ledgers from ZK for hash node " + level0 + "/" + level1 + "/" + level2 + "/" + level3 + " : " + zkActiveLedgers);
            }
            return new LedgerManager.LedgerRange(zkActiveLedgers.subSet(LongHierarchicalLedgerManager.this.getStartLedgerIdByLevel(level0, level1, level2, level3), true, LongHierarchicalLedgerManager.this.getEndLedgerIdByLevel(level0, level1, level2, level3), true));
        }
    }

    private class RecursiveProcessor
    implements BookkeeperInternalCallbacks.Processor<String> {
        private final int level;
        private final String path;
        private final BookkeeperInternalCallbacks.Processor<Long> processor;
        private final Object context;
        private final int successRc;
        private final int failureRc;

        private RecursiveProcessor(int level, String path, BookkeeperInternalCallbacks.Processor<Long> processor, Object context, int successRc, int failureRc) {
            this.level = level;
            this.path = path;
            this.processor = processor;
            this.context = context;
            this.successRc = successRc;
            this.failureRc = failureRc;
        }

        @Override
        public void process(String lNode, AsyncCallback.VoidCallback cb) {
            String nodePath = this.path + "/" + lNode;
            if (this.level == 0 && LongHierarchicalLedgerManager.isSpecialZnode(lNode)) {
                cb.processResult(this.successRc, null, this.context);
                return;
            }
            if (this.level < 3) {
                LongHierarchicalLedgerManager.this.asyncProcessLevelNodes(nodePath, new RecursiveProcessor(this.level + 1, nodePath, this.processor, this.context, this.successRc, this.failureRc), cb, this.context, this.successRc, this.failureRc);
            } else {
                LongHierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(nodePath, this.processor, cb, this.context, this.successRc, this.failureRc);
            }
        }
    }
}

