/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.streaming;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerOutputStream.class);
    private final LedgerHandle lh;
    private ByteBuffer bytebuff;
    byte[] bbytes;
    int defaultSize = 0x100000;

    public LedgerOutputStream(LedgerHandle lh) {
        this.lh = lh;
        this.bbytes = new byte[this.defaultSize];
        this.bytebuff = ByteBuffer.wrap(this.bbytes);
    }

    public LedgerOutputStream(LedgerHandle lh, int size) {
        this.lh = lh;
        this.bbytes = new byte[size];
        this.bytebuff = ByteBuffer.wrap(this.bbytes);
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public synchronized void flush() {
        if (this.bytebuff.position() > 0) {
            byte[] b = new byte[this.bytebuff.position()];
            LOG.info("Comment: flushing with params  " + this.bytebuff.position());
            System.arraycopy(this.bbytes, 0, b, 0, this.bytebuff.position());
            try {
                this.lh.addEntry(b);
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted while flusing " + ie);
                Thread.currentThread().interrupt();
            }
            catch (BKException bke) {
                LOG.warn("BookKeeper exception ", (Throwable)bke);
            }
        }
    }

    private boolean makeSpace(int len) {
        if (this.bytebuff.remaining() < len) {
            this.flush();
            this.bytebuff.clear();
            if (this.bytebuff.capacity() < len) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void write(byte[] b) {
        if (this.makeSpace(b.length)) {
            this.bytebuff.put(b);
        } else {
            try {
                this.lh.addEntry(b);
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted while writing", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            catch (BKException bke) {
                LOG.warn("BookKeeper exception", (Throwable)bke);
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (!this.makeSpace(len)) {
            this.bbytes = new byte[len];
            this.bytebuff = ByteBuffer.wrap(this.bbytes);
        }
        this.bytebuff.put(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.makeSpace(1);
        byte oneB = (byte)(b & 0xFF);
        this.bytebuff.put(oneB);
    }
}

