/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.OptionInfo;
import com.twitter.common.args.Positional;
import com.twitter.common.args.PositionalInfo;
import com.twitter.common.args.apt.Configuration;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public final class Args {
    @VisibleForTesting
    static final Function<Configuration.ArgInfo, Optional<Field>> TO_FIELD = new Function<Configuration.ArgInfo, Optional<Field>>(){

        public Optional<Field> apply(Configuration.ArgInfo info) {
            try {
                return Optional.of((Object)Class.forName(info.className).getDeclaredField(info.fieldName));
            }
            catch (NoSuchFieldException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.fine(String.format("Not on current classpath, skipping %s", info));
                return Optional.absent();
            }
        }
    };
    private static final Logger LOG = Logger.getLogger(Args.class.getName());
    private static final Function<Field, OptionInfo<?>> TO_OPTION_INFO = new Function<Field, OptionInfo<?>>(){

        public OptionInfo<?> apply(Field field) {
            CmdLine cmdLine = field.getAnnotation(CmdLine.class);
            if (cmdLine == null) {
                throw new Configuration.ConfigurationException("No @CmdLine Arg annotation for field " + field, new Object[0]);
            }
            return OptionInfo.createFromField(field);
        }
    };
    private static final Function<Field, PositionalInfo<?>> TO_POSITIONAL_INFO = new Function<Field, PositionalInfo<?>>(){

        public PositionalInfo<?> apply(Field field) {
            Positional positional = field.getAnnotation(Positional.class);
            if (positional == null) {
                throw new Configuration.ConfigurationException("No @Positional Arg annotation for field " + field, new Object[0]);
            }
            return PositionalInfo.createFromField(field);
        }
    };

    static ArgsInfo fromConfiguration(Configuration configuration, Predicate<Field> filter) {
        ImmutableSet positionalFields = ImmutableSet.copyOf(Args.filterFields(configuration.positionalInfo(), filter));
        if (positionalFields.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %d fields marked for @Positional Args after applying filter - only 1 is allowed:\n\t%s", positionalFields.size(), Joiner.on((String)"\n\t").join((Iterable)positionalFields)));
        }
        Optional positionalInfo = Optional.fromNullable((Object)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)positionalFields, TO_POSITIONAL_INFO), null));
        Iterable optionInfos = Iterables.transform(Args.filterFields(configuration.optionInfo(), filter), TO_OPTION_INFO);
        return new ArgsInfo(configuration, positionalInfo, optionInfos);
    }

    private static Iterable<Field> filterFields(Iterable<Configuration.ArgInfo> infos, Predicate<Field> filter) {
        return Iterables.filter((Iterable)Optional.presentInstances((Iterable)Iterables.transform(infos, TO_FIELD)), filter);
    }

    public static ArgsInfo from(Object ... sources) throws IOException {
        return Args.from(ImmutableList.copyOf((Object[])sources));
    }

    public static ArgsInfo from(Predicate<Field> filter, Object ... sources) throws IOException {
        return Args.from(filter, ImmutableList.copyOf((Object[])sources));
    }

    public static ArgsInfo from(Iterable<?> sources) throws IOException {
        return Args.from((Predicate<Field>)Predicates.alwaysTrue(), sources);
    }

    public static ArgsInfo from(Predicate<Field> filter, Iterable<?> sources) throws IOException {
        Preconditions.checkNotNull(filter);
        Preconditions.checkNotNull(sources);
        Configuration configuration = Configuration.load();
        ArgsInfo staticInfo = Args.fromConfiguration(configuration, filter);
        ImmutableSet.Builder positionalInfos = ImmutableSet.builder().addAll((Iterable)staticInfo.getPositionalInfo().asSet());
        ImmutableSet.Builder optionInfos = ImmutableSet.builder().addAll(staticInfo.getOptionInfos());
        for (Object source : sources) {
            Class<?> clazz = source instanceof Class ? (Class<?>)source : source.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                if (!filter.apply((Object)field)) continue;
                boolean cmdLine = field.isAnnotationPresent(CmdLine.class);
                boolean positional = field.isAnnotationPresent(Positional.class);
                if (cmdLine && positional) {
                    throw new IllegalArgumentException("An Arg cannot be annotated with both @CmdLine and @Positional, found bad Arg field: " + field);
                }
                if (cmdLine) {
                    optionInfos.add(OptionInfo.createFromField(field, source));
                    continue;
                }
                if (!positional) continue;
                positionalInfos.add(PositionalInfo.createFromField(field, source));
            }
        }
        PositionalInfo positionalInfo = (PositionalInfo)Iterables.getOnlyElement((Iterable)positionalInfos.build(), null);
        return new ArgsInfo(configuration, (Optional<? extends PositionalInfo<?>>)Optional.fromNullable((Object)positionalInfo), (Iterable<? extends OptionInfo<?>>)optionInfos.build());
    }

    private Args() {
    }

    public static final class ArgsInfo {
        private final Configuration configuration;
        private final Optional<? extends PositionalInfo<?>> positionalInfo;
        private final ImmutableList<? extends OptionInfo<?>> optionInfos;

        ArgsInfo(Configuration configuration, Optional<? extends PositionalInfo<?>> positionalInfo, Iterable<? extends OptionInfo<?>> optionInfos) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
            this.positionalInfo = (Optional)Preconditions.checkNotNull(positionalInfo);
            this.optionInfos = ImmutableList.copyOf(optionInfos);
        }

        Configuration getConfiguration() {
            return this.configuration;
        }

        Optional<? extends PositionalInfo<?>> getPositionalInfo() {
            return this.positionalInfo;
        }

        ImmutableList<? extends OptionInfo<?>> getOptionInfos() {
            return this.optionInfos;
        }
    }
}

