/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import org.apache.distributedlog.client.routing.ServerSetWatcher;
import org.apache.distributedlog.service.DLSocketAddress;

public class TwitterServerSetWatcher
implements ServerSetWatcher {
    private final ServerSet serverSet;
    private final boolean resolvedFromName;

    public TwitterServerSetWatcher(ServerSet serverSet, boolean resolvedFromName) {
        this.serverSet = serverSet;
        this.resolvedFromName = resolvedFromName;
    }

    @Override
    public void watch(final ServerSetWatcher.ServerSetMonitor monitor) throws ServerSetWatcher.MonitorException {
        try {
            this.serverSet.watch((DynamicHostSet.HostChangeMonitor)new DynamicHostSet.HostChangeMonitor<ServiceInstance>(){

                public void onChange(ImmutableSet<ServiceInstance> serviceInstances) {
                    HashSet dlServers = Sets.newHashSet();
                    for (ServiceInstance serviceInstance : serviceInstances) {
                        Endpoint endpoint = (Endpoint)serviceInstance.getAdditionalEndpoints().get("thrift");
                        InetSocketAddress inetAddr = new InetSocketAddress(endpoint.getHost(), endpoint.getPort());
                        int shardId = TwitterServerSetWatcher.this.resolvedFromName ? -1 : serviceInstance.getShard();
                        DLSocketAddress address = new DLSocketAddress(shardId, inetAddr);
                        dlServers.add(address);
                    }
                    monitor.onChange((ImmutableSet<DLSocketAddress>)ImmutableSet.copyOf((Collection)dlServers));
                }
            });
        }
        catch (DynamicHostSet.MonitorException me) {
            throw new ServerSetWatcher.MonitorException("Failed to monitor server set : ", me);
        }
    }
}

