/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.stats;

import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.stats.ClientStatsLogger;
import org.apache.distributedlog.client.stats.OpStats;
import org.apache.distributedlog.thrift.service.StatusCode;

public class ClientStats {
    private final RegionResolver regionResolver;
    private final StatsReceiver statsReceiver;
    private final ClientStatsLogger clientStatsLogger;
    private final boolean enableRegionStats;
    private final ConcurrentMap<String, ClientStatsLogger> regionClientStatsLoggers;
    private final ConcurrentMap<String, OpStats> opStatsMap;

    public ClientStats(StatsReceiver statsReceiver, boolean enableRegionStats, RegionResolver regionResolver) {
        this.statsReceiver = statsReceiver;
        this.clientStatsLogger = new ClientStatsLogger(statsReceiver);
        this.enableRegionStats = enableRegionStats;
        this.regionClientStatsLoggers = new ConcurrentHashMap<String, ClientStatsLogger>();
        this.regionResolver = regionResolver;
        this.opStatsMap = new ConcurrentHashMap<String, OpStats>();
    }

    public OpStats getOpStats(String op) {
        OpStats opStats = (OpStats)this.opStatsMap.get(op);
        if (null != opStats) {
            return opStats;
        }
        OpStats newStats = new OpStats(this.statsReceiver.scope(op), this.enableRegionStats, this.regionResolver);
        OpStats oldStats = this.opStatsMap.putIfAbsent(op, newStats);
        if (null == oldStats) {
            return newStats;
        }
        return oldStats;
    }

    private ClientStatsLogger getRegionClientStatsLogger(SocketAddress address) {
        String region = this.regionResolver.resolveRegion(address);
        return this.getRegionClientStatsLogger(region);
    }

    private ClientStatsLogger getRegionClientStatsLogger(String region) {
        ClientStatsLogger statsLogger = (ClientStatsLogger)this.regionClientStatsLoggers.get(region);
        if (null == statsLogger) {
            ClientStatsLogger newStatsLogger = new ClientStatsLogger(this.statsReceiver.scope(region));
            ClientStatsLogger oldStatsLogger = this.regionClientStatsLoggers.putIfAbsent(region, newStatsLogger);
            statsLogger = null == oldStatsLogger ? newStatsLogger : oldStatsLogger;
        }
        return statsLogger;
    }

    public StatsReceiver getFinagleStatsReceiver(SocketAddress addr) {
        if (this.enableRegionStats && null != addr) {
            return this.getRegionClientStatsLogger(addr).getStatsReceiver();
        }
        return this.clientStatsLogger.getStatsReceiver();
    }

    public void completeProxyRequest(SocketAddress addr, StatusCode code, long startTimeNanos) {
        this.clientStatsLogger.completeProxyRequest(code, startTimeNanos);
        if (this.enableRegionStats && null != addr) {
            this.getRegionClientStatsLogger(addr).completeProxyRequest(code, startTimeNanos);
        }
    }

    public void failProxyRequest(SocketAddress addr, Throwable cause, long startTimeNanos) {
        this.clientStatsLogger.failProxyRequest(cause, startTimeNanos);
        if (this.enableRegionStats && null != addr) {
            this.getRegionClientStatsLogger(addr).failProxyRequest(cause, startTimeNanos);
        }
    }
}

