/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.logsegment;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.impl.logsegment.BKUtils;
import org.apache.distributedlog.logsegment.LogSegmentRandomAccessEntryReader;

class BKLogSegmentRandomAccessEntryReader
implements LogSegmentRandomAccessEntryReader,
AsyncCallback.ReadCallback {
    private final long lssn;
    private final long startSequenceId;
    private final boolean envelopeEntries;
    private final boolean deserializeRecordSet;
    private final LogSegmentMetadata metadata;
    private final LedgerHandle lh;
    private CompletableFuture<Void> closePromise = null;

    BKLogSegmentRandomAccessEntryReader(LogSegmentMetadata metadata, LedgerHandle lh, DistributedLogConfiguration conf) {
        this.metadata = metadata;
        this.lssn = metadata.getLogSegmentSequenceNumber();
        this.startSequenceId = metadata.getStartSequenceId();
        this.envelopeEntries = metadata.getEnvelopeEntries();
        this.deserializeRecordSet = conf.getDeserializeRecordSetOnReads();
        this.lh = lh;
    }

    @Override
    public long getLastAddConfirmed() {
        return this.lh.getLastAddConfirmed();
    }

    @Override
    public CompletableFuture<List<Entry.Reader>> readEntries(long startEntryId, long endEntryId) {
        CompletableFuture<List<Entry.Reader>> promise = new CompletableFuture<List<Entry.Reader>>();
        this.lh.asyncReadEntries(startEntryId, endEntryId, (AsyncCallback.ReadCallback)this, promise);
        return promise;
    }

    Entry.Reader processReadEntry(LedgerEntry entry) throws IOException {
        return Entry.newBuilder().setLogSegmentInfo(this.lssn, this.startSequenceId).setEntryId(entry.getEntryId()).setEnvelopeEntry(this.envelopeEntries).deserializeRecordSet(this.deserializeRecordSet).setEntry(entry.getEntryBuffer()).buildReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> entries, Object ctx) {
        CompletableFuture promise = (CompletableFuture)ctx;
        if (0 == rc) {
            ArrayList entryList = Lists.newArrayList();
            while (entries.hasMoreElements()) {
                LedgerEntry entry = entries.nextElement();
                try {
                    entryList.add(this.processReadEntry(entry));
                }
                catch (IOException ioe) {
                    while (entries.hasMoreElements()) {
                        LedgerEntry le = entries.nextElement();
                        le.getEntryBuffer().release();
                    }
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)ioe);
                    return;
                }
                finally {
                    entry.getEntryBuffer().release();
                }
            }
            FutureUtils.complete((CompletableFuture)promise, (Object)entryList);
        } else {
            FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new BKTransmitException("Failed to read entries :", rc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        CompletableFuture<Void> closeFuture;
        BKLogSegmentRandomAccessEntryReader bKLogSegmentRandomAccessEntryReader = this;
        synchronized (bKLogSegmentRandomAccessEntryReader) {
            if (null != this.closePromise) {
                return this.closePromise;
            }
            this.closePromise = new CompletableFuture<Void>();
            closeFuture = this.closePromise;
        }
        FutureUtils.proxyTo(BKUtils.closeLedgers(this.lh), closeFuture);
        return closeFuture;
    }
}

