/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.twitter.common.base.ExceptionalCommand;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.util.CommandExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RetryingRunnable<E extends Exception>
implements Runnable {
    private final String name;
    private final int tryNum;
    private final int numTries;
    private final Amount<Long, Time> retryDelay;
    private final ExceptionalCommand<E> task;
    private final CommandExecutor commandExecutor;
    private final Class<E> exceptionClass;
    private static final Logger LOG = Logger.getLogger(RetryingRunnable.class.getName());

    public RetryingRunnable(String name, ExceptionalCommand<E> task, Class<E> exceptionClass, int numTries, Amount<Long, Time> retryDelay, CommandExecutor commandExecutor, int tryNum) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.task = (ExceptionalCommand)Preconditions.checkNotNull(task);
        this.exceptionClass = (Class)Preconditions.checkNotNull(exceptionClass);
        this.retryDelay = (Amount)Preconditions.checkNotNull(retryDelay);
        this.commandExecutor = (CommandExecutor)Preconditions.checkNotNull((Object)commandExecutor);
        Preconditions.checkArgument((numTries > 0 ? 1 : 0) != 0);
        this.tryNum = tryNum;
        this.numTries = numTries;
    }

    public RetryingRunnable(String name, ExceptionalCommand<E> task, Class<E> exceptionClass, int numTries, Amount<Long, Time> retryDelay, CommandExecutor commandExecutor) {
        this(name, task, exceptionClass, numTries, retryDelay, commandExecutor, 1);
    }

    @Override
    public void run() {
        try {
            this.task.execute();
        }
        catch (Exception e) {
            if (e.getClass().isAssignableFrom(this.exceptionClass)) {
                if (this.tryNum < this.numTries) {
                    this.commandExecutor.execute(this.name, this.task, this.exceptionClass, this.numTries - 1, this.retryDelay);
                } else {
                    LOG.log(Level.INFO, "Giving up on task: " + this.name + " " + "after " + "trying " + this.numTries + " times" + ".", e);
                }
            }
            LOG.log(Level.INFO, "Giving up on task: " + this.name + " after trying " + this.numTries + " times. " + "due to unhandled exception ", e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("tryNum", this.tryNum).append("numTries", this.numTries).append("retryDelay", this.retryDelay).toString();
    }
}

