/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.protocol.util;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.thrift.service.ResponseHeader;

public class ProtocolUtils {
    private static final ThreadLocal<CRC32> requestCRC = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long writeOpCRC32(String stream, ByteBuf data) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes(Charsets.UTF_8));
            crc.update(data.nioBuffer());
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long writeOpCRC32(String stream, ByteBuffer data) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes(Charsets.UTF_8));
            crc.update(data);
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long truncateOpCRC32(String stream, DLSN dlsn) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes(Charsets.UTF_8));
            crc.update(dlsn.serializeBytes());
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    public static Long streamOpCRC32(String stream) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes(Charsets.UTF_8));
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    public static DLException exception(ResponseHeader response) {
        switch (response.getCode()) {
            case FOUND: {
                String errMsg = response.isSetErrMsg() ? response.getErrMsg() : "Request is redirected to " + response.getLocation();
                return new OwnershipAcquireFailedException(errMsg, response.getLocation());
            }
            case SUCCESS: {
                throw new IllegalArgumentException("Can't instantiate an exception for success response.");
            }
        }
        String errMsg = response.isSetErrMsg() ? response.getErrMsg() : response.getCode().name();
        return new DLException(response.getCode().getValue(), errMsg);
    }
}

