/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.quantity;

import com.google.common.base.Preconditions;
import com.twitter.common.collections.Pair;
import com.twitter.common.quantity.Unit;

public abstract class Amount<T extends Number, U extends Unit<U>>
implements Comparable<Amount<T, U>> {
    private final Pair<T, U> amount;
    private final T maxValue;

    private Amount(T value, U unit, T maxValue) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(unit);
        this.maxValue = maxValue;
        this.amount = Pair.of(value, unit);
    }

    public T getValue() {
        return (T)((Number)this.amount.getFirst());
    }

    public U getUnit() {
        return (U)((Unit)this.amount.getSecond());
    }

    public T as(U unit) {
        return this.asUnit((Unit<?>)unit);
    }

    public T asChecked(U unit) {
        T retVal = this.asUnit((Unit<?>)unit);
        if (retVal.equals(this.maxValue)) {
            throw new TypeOverflowException();
        }
        return retVal;
    }

    private T asUnit(Unit<?> unit) {
        return this.sameUnits(unit) ? this.getValue() : this.scale(this.getUnit().multiplier() / unit.multiplier());
    }

    public int hashCode() {
        return this.amount.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Amount)) {
            return false;
        }
        Amount other = (Amount)obj;
        return this.amount.equals(other.amount) || this.isSameAmount(other);
    }

    private boolean isSameAmount(Amount<?, ?> other) {
        Object value = other.getValue();
        if (!this.getValue().getClass().isInstance(value)) {
            return false;
        }
        Object unit = other.getUnit();
        if (!this.getUnit().getClass().isInstance(unit)) {
            return false;
        }
        Object otherUnit = other.getUnit();
        return this.isSameAmount(other, otherUnit);
    }

    private boolean isSameAmount(Amount<?, ?> other, U otherUnit) {
        if (otherUnit.multiplier() > this.getUnit().multiplier()) {
            return this.getValue().equals(super.asUnit((Unit<?>)this.getUnit()));
        }
        return this.as(otherUnit).equals(other.getValue());
    }

    public String toString() {
        return this.amount.toString();
    }

    @Override
    public int compareTo(Amount<T, U> other) {
        if (other.getUnit().multiplier() > this.getUnit().multiplier()) {
            return ((Comparable)this.getValue()).compareTo(other.as(this.getUnit()));
        }
        return ((Comparable)this.as(other.getUnit())).compareTo(other.getValue());
    }

    private boolean sameUnits(Unit<? extends Unit<?>> unit) {
        return this.getUnit().equals(unit);
    }

    protected abstract T scale(double var1);

    public static <U extends Unit<U>> Amount<Double, U> of(double number, U unit) {
        return new Amount<Double, U>(number, unit, Double.valueOf(Double.MAX_VALUE)){

            @Override
            protected Double scale(double multiplier) {
                return (Double)this.getValue() * multiplier;
            }
        };
    }

    public static <U extends Unit<U>> Amount<Float, U> of(float number, U unit) {
        return new Amount<Float, U>(Float.valueOf(number), unit, Float.valueOf(Float.MAX_VALUE)){

            @Override
            protected Float scale(double multiplier) {
                return Float.valueOf((float)((double)((Float)this.getValue()).floatValue() * multiplier));
            }
        };
    }

    public static <U extends Unit<U>> Amount<Long, U> of(long number, U unit) {
        return new Amount<Long, U>(number, unit, Long.MAX_VALUE){

            @Override
            protected Long scale(double multiplier) {
                return (long)((double)((Long)this.getValue()).longValue() * multiplier);
            }
        };
    }

    public static <U extends Unit<U>> Amount<Integer, U> of(int number, U unit) {
        return new Amount<Integer, U>(number, unit, Integer.MAX_VALUE){

            @Override
            protected Integer scale(double multiplier) {
                return (int)((double)((Integer)this.getValue()).intValue() * multiplier);
            }
        };
    }

    /* synthetic */ Amount(Number x0, Unit x1, Number x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class TypeOverflowException
    extends RuntimeException {
    }
}

