/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.twitter.common.stats.Percentile;
import com.twitter.common.stats.Rate;
import com.twitter.common.stats.Ratio;
import com.twitter.common.stats.SlidingStats;
import com.twitter.common.stats.Stats;
import com.twitter.common.stats.StatsProvider;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class RequestStats
implements StatsProvider.RequestTimer {
    private static final float DEFAULT_SAMPLE_PERCENT = 10.0f;
    private static final double[] DEFAULT_PERCENTILES = new double[]{10.0, 50.0, 90.0, 99.0, 99.9, 99.99};
    private final SlidingStats requests;
    private final Percentile<Long> percentile;
    private final AtomicLong errors;
    private final AtomicLong reconnects;
    private final AtomicLong timeouts;

    public RequestStats(String name) {
        this(name, new Percentile<Long>(name, 10.0f, DEFAULT_PERCENTILES));
    }

    public RequestStats(String name, @Nullable Percentile<Long> percentile) {
        this.requests = new SlidingStats(name + "_requests", "micros");
        this.percentile = percentile;
        this.errors = Stats.exportLong(name + "_errors");
        this.reconnects = Stats.exportLong(name + "_reconnects");
        this.timeouts = Stats.exportLong(name + "_timeouts");
        Rate<AtomicLong> requestsPerSec = Rate.of(name + "_requests_per_sec", this.requests.getEventCounter()).build();
        Stats.export(Ratio.of(name + "_error_rate", Rate.of(name + "_errors_per_sec", this.errors).build(), requestsPerSec));
        Rate<AtomicLong> timeoutsPerSec = Rate.of(name + "_timeouts_per_sec", this.timeouts).build();
        Stats.export(timeoutsPerSec);
        Stats.export(Ratio.of(name + "_timeout_rate", timeoutsPerSec, requestsPerSec));
    }

    public SlidingStats getSlidingStats() {
        return this.requests;
    }

    public AtomicLong getErrorCounter() {
        return this.errors;
    }

    public AtomicLong getReconnectCounter() {
        return this.reconnects;
    }

    public AtomicLong getTimeoutCounter() {
        return this.timeouts;
    }

    public Percentile<Long> getPercentile() {
        return this.percentile;
    }

    public void requestComplete(long latencyMicros) {
        this.requests.accumulate(latencyMicros);
        if (this.percentile != null) {
            this.percentile.record(latencyMicros);
        }
    }

    public void incErrors() {
        this.requestComplete(0L);
        this.errors.incrementAndGet();
    }

    public void incErrors(long latencyMicros) {
        this.requestComplete(latencyMicros);
        this.errors.incrementAndGet();
    }

    public void incReconnects() {
        this.reconnects.incrementAndGet();
    }

    public void incTimeouts() {
        this.timeouts.incrementAndGet();
    }

    public long getErrorCount() {
        return this.errors.get();
    }

    public long getReconnectCount() {
        return this.reconnects.get();
    }

    public long getTimeoutCount() {
        return this.timeouts.get();
    }
}

