/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import org.apache.distributedlog.service.balancer.StreamChooser;

public class LimitedStreamChooser
implements StreamChooser {
    final StreamChooser underlying;
    int limit;

    public static LimitedStreamChooser of(StreamChooser underlying, int limit) {
        return new LimitedStreamChooser(underlying, limit);
    }

    LimitedStreamChooser(StreamChooser underlying, int limit) {
        this.underlying = underlying;
        this.limit = limit;
    }

    @Override
    public synchronized String choose() {
        if (this.limit <= 0) {
            return null;
        }
        String s = this.underlying.choose();
        if (s == null) {
            this.limit = 0;
            return null;
        }
        --this.limit;
        return s;
    }
}

