/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.streamset;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.service.streamset.Partition;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;

public abstract class CacheableStreamPartitionConverter
implements StreamPartitionConverter {
    private final ConcurrentMap<String, Partition> partitions = new ConcurrentHashMap<String, Partition>();

    protected CacheableStreamPartitionConverter() {
    }

    @Override
    public Partition convert(String streamName) {
        Partition p = (Partition)this.partitions.get(streamName);
        if (null != p) {
            return p;
        }
        Partition newPartition = this.newPartition(streamName);
        Partition oldPartition = this.partitions.putIfAbsent(streamName, newPartition);
        if (null == oldPartition) {
            return newPartition;
        }
        return oldPartition;
    }

    protected abstract Partition newPartition(String var1);
}

