/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.rabbit;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.entity.messaging.amqp.AmqpExchange;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitBroker;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitDestination
extends AbstractEntity
implements AmqpExchange {
    public static final Logger log = LoggerFactory.getLogger(RabbitDestination.class);
    private String virtualHost;
    private String exchange;
    protected SshMachineLocation machine;
    protected Map<String, String> shellEnvironment;

    public void onManagementStarting() {
        super.onManagementStarting();
        this.exchange = this.getConfig((ConfigKey.HasConfigKey)EXCHANGE_NAME) != null ? (String)this.getConfig((ConfigKey.HasConfigKey)EXCHANGE_NAME) : this.getDefaultExchangeName();
        this.virtualHost = (String)this.getConfig((ConfigKey.HasConfigKey)RabbitBroker.VIRTUAL_HOST_NAME);
        this.sensors().set((AttributeSensor)RabbitBroker.VIRTUAL_HOST_NAME, (Object)this.virtualHost);
        this.machine = (SshMachineLocation)Iterables.find((Iterable)this.getParent().getLocations(), (Predicate)Predicates.instanceOf(SshMachineLocation.class));
        this.shellEnvironment = this.getParent().getShellEnvironment();
    }

    public RabbitBroker getParent() {
        return (RabbitBroker)super.getParent();
    }

    public void create() {
        this.connectSensors();
    }

    public void delete() {
        this.disconnectSensors();
    }

    protected void connectSensors() {
    }

    protected void disconnectSensors() {
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public String getExchangeName() {
        return this.exchange;
    }

    public String getDefaultExchangeName() {
        return "amq.direct";
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("virtualHost", (Object)this.getParent().getVirtualHost()).add("exchange", (Object)this.getExchangeName());
    }
}

