/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.hazelcast;

import com.google.common.base.Functions;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNode;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastNodeImpl
extends SoftwareProcessImpl
implements HazelcastNode {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastNodeImpl.class);
    HttpFeed httpFeed;

    public Class<HazelcastNodeDriver> getDriverInterface() {
        return HazelcastNodeDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting sensors for node: {} ", this.getAttribute(Attributes.HOSTNAME));
        }
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getNodePort());
        String nodeUri = String.format("http://%s:%d/hazelcast/rest/cluster", hp.getHostText(), hp.getPort());
        this.sensors().set(Attributes.MAIN_URI, (Object)URI.create(nodeUri));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node {} is using {} as a main URI", (Object)this, (Object)nodeUri);
        }
        this.httpFeed = HttpFeed.builder().entity((Entity)this).period(3000L, TimeUnit.MILLISECONDS).baseUri(nodeUri).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    protected void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disconnecting sensors for node: {} ", this.getAttribute(Attributes.HOSTNAME));
        }
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    @Override
    public String getGroupName() {
        return (String)this.getConfig(HazelcastNode.GROUP_NAME);
    }

    @Override
    public String getGroupPassword() {
        return (String)this.getConfig(HazelcastNode.GROUP_PASSWORD);
    }

    @Override
    public String getNodeName() {
        return (String)this.getAttribute((AttributeSensor)HazelcastNode.NODE_NAME);
    }

    @Override
    public Integer getNodePort() {
        return (Integer)this.getAttribute((AttributeSensor)HazelcastNode.NODE_PORT);
    }

    @Override
    public String getHostname() {
        return (String)this.getAttribute(HOSTNAME);
    }

    @Override
    public String getHostAddress() {
        return (String)this.getAttribute(ADDRESS);
    }

    @Override
    public String getPrivateIpAddress() {
        return (String)this.getAttribute(SUBNET_ADDRESS);
    }

    @Override
    public String getListenAddress() {
        String listenAddress = this.getPrivateIpAddress();
        if (Strings.isBlank((CharSequence)listenAddress)) {
            listenAddress = (String)this.getAttribute(ADDRESS);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Node {} is listening on {}", (Object)this, (Object)listenAddress);
        }
        return listenAddress;
    }

    @Override
    public String getHeapMemorySize() {
        return (String)this.getConfig(HazelcastNode.NODE_HEAP_MEMORY_SIZE);
    }
}

