/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.ipblock;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.profitbricks.domain.IpBlock;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;
import org.jclouds.profitbricks.http.parser.publicip.PublicIpListResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseIpBlockResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected final PublicIpListResponseHandler publicIpListResponseHandler;
    protected List<String> ips;
    protected IpBlock.Builder builder = IpBlock.builder();
    protected boolean usePublicIpListParser = false;

    BaseIpBlockResponseHandler(PublicIpListResponseHandler publicIpListResponseHandler) {
        this.publicIpListResponseHandler = publicIpListResponseHandler;
        this.ips = Lists.newArrayList();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("publicIps".equals(qName)) {
            this.usePublicIpListParser = true;
        }
        if (this.usePublicIpListParser) {
            this.publicIpListResponseHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.usePublicIpListParser) {
            this.publicIpListResponseHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("blockId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("location".equals(qName)) {
            this.builder.location(Location.fromId(this.textToStringValue()));
        } else if ("ips".equals(qName)) {
            this.ips.add(this.textToStringValue());
        }
    }
}

