/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.WrappedConfigKey;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    public static <T> T getRequiredConfig(Entity entity, ConfigKey<T> key) {
        Object result = entity.getConfig(key);
        if (result == null) {
            throw new IllegalStateException("Configuration " + key + " is required");
        }
        return (T)result;
    }

    public static <T> ConfigKey<T> prefixedKey(String prefix, ConfigKey<T> key) {
        return ConfigKeys.newConfigKeyWithPrefix(prefix, key);
    }

    public static <T> ConfigKey<T> unprefixedKey(String prefix, ConfigKey<T> key) {
        String newName = key.getName();
        if (newName.startsWith(prefix)) {
            newName = newName.substring(prefix.length());
        } else {
            log.warn("Cannot remove prefix " + prefix + " from key " + key + " (ignoring)");
        }
        return new BasicConfigKey<Object>(key.getTypeToken(), newName, key.getDescription(), key.getDefaultValue());
    }

    public static BrooklynProperties loadFromFile(String file) {
        BrooklynProperties result = BrooklynProperties.Factory.newEmpty();
        if (file != null) {
            result.addFrom(new File(file));
        }
        return result;
    }

    public static BrooklynProperties filterFor(BrooklynProperties properties, Predicate<? super String> filter) {
        BrooklynProperties result = BrooklynProperties.Factory.newEmpty();
        Set keys = properties.findKeys(ConfigPredicates.nameSatisfies(filter));
        for (ConfigKey key : keys) {
            result.put(key, properties.getConfig(key));
        }
        return result;
    }

    public static BrooklynProperties filterForPrefix(BrooklynProperties properties, String prefix) {
        BrooklynProperties result = BrooklynProperties.Factory.newEmpty();
        Set keys = properties.findKeys(ConfigPredicates.nameSatisfies((Predicate<? super String>)StringPredicates.startsWith((String)prefix)));
        for (ConfigKey key : keys) {
            result.put(key, properties.getConfig(key));
        }
        return result;
    }

    public static BrooklynProperties filterForPrefixAndStrip(Map<String, ?> properties, String prefix) {
        BrooklynProperties result = BrooklynProperties.Factory.newEmpty();
        for (String k : properties.keySet()) {
            if (!k.startsWith(prefix)) continue;
            result.put(k.substring(prefix.length()), properties.get(k));
        }
        return result;
    }

    public static Set<ConfigKey.HasConfigKey<?>> getStaticKeysOnClass(Class<?> type) {
        LinkedHashSet<ConfigKey.HasConfigKey> result = new LinkedHashSet<ConfigKey.HasConfigKey>();
        for (Field f : type.getFields()) {
            try {
                if ((f.getModifiers() & 8) == 0) continue;
                if (ConfigKey.class.isAssignableFrom(f.getType())) {
                    result.add(new WrappedConfigKey((ConfigKey)f.get(null)));
                    continue;
                }
                if (!ConfigKey.HasConfigKey.class.isAssignableFrom(f.getType())) continue;
                result.add((ConfigKey.HasConfigKey)f.get(null));
            }
            catch (Exception e) {
                log.error("Error retrieving config key for field " + f + " on class " + type + "; rethrowing", (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static void addUnprefixedConfigKeyInConfigBack(String configPrefix, ConfigBag configBag, Map<String, Object> destinationBucket) {
        for (Map.Entry<ConfigKey<?>, ?> entry : configBag.getAllConfigAsConfigKeyMap().entrySet()) {
            String keyName = entry.getKey().getName();
            if (!keyName.startsWith(configPrefix)) continue;
            destinationBucket.put(Strings.removeFromStart((String)keyName, (String)configPrefix), entry.getValue());
        }
    }
}

