/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectorBase<T>
implements Effector<T> {
    private static final Logger log = LoggerFactory.getLogger(EffectorBase.class);
    private static final long serialVersionUID = -4153962199078384835L;
    private final String name;
    private final Class<T> returnType;
    private final List<ParameterType<?>> parameters;
    private final String description;

    public EffectorBase(String name, Class<T> returnType, List<ParameterType<?>> parameters, String description) {
        this.name = name;
        this.returnType = returnType;
        this.parameters = new ArrayList(parameters);
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeName() {
        return this.returnType.getCanonicalName();
    }

    public List<ParameterType<?>> getParameters() {
        return this.parameters;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (ParameterType<?> parameter : this.parameters) {
            String parameterName = parameter.getName() != null ? parameter.getName() : "<unknown>";
            parameterNames.add(parameterName);
        }
        return this.name + "[" + Joiner.on((String)",").join(parameterNames) + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.returnType, this.parameters, this.description});
    }

    public boolean equals(Object other) {
        if (!(other instanceof EffectorBase)) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        if (!Objects.equal((Object)this.hashCode(), (Object)other.hashCode())) {
            return false;
        }
        return Objects.equal((Object)this.getName(), (Object)((EffectorBase)other).getName()) && Objects.equal(this.getReturnType(), ((EffectorBase)other).getReturnType()) && Objects.equal(this.getParameters(), ((EffectorBase)other).getParameters()) && Objects.equal((Object)this.getDescription(), (Object)((EffectorBase)other).getDescription());
    }
}

