/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.util.collections.MutableMap;

public class ManagementPlaneSyncRecordImpl
implements ManagementPlaneSyncRecord,
Serializable {
    private static final long serialVersionUID = -4207907303446336973L;
    private String planeId;
    private String masterNodeId;
    private Map<String, ManagementNodeSyncRecord> managementNodes;

    public static Builder builder() {
        return new Builder();
    }

    private ManagementPlaneSyncRecordImpl(Builder builder) {
        this.planeId = builder.planeId;
        this.masterNodeId = builder.masterNodeId;
        this.managementNodes = Maps.newLinkedHashMap();
        for (ManagementNodeSyncRecord node : builder.nodes.values()) {
            Preconditions.checkState((!this.managementNodes.containsKey(node.getNodeId()) ? 1 : 0) != 0, (String)"duplicate nodeId %s", (Object[])new Object[]{node.getNodeId()});
            this.managementNodes.put(node.getNodeId(), node);
        }
    }

    public String getPlaneId() {
        return this.planeId;
    }

    public String getMasterNodeId() {
        return this.masterNodeId;
    }

    public Map<String, ManagementNodeSyncRecord> getManagementNodes() {
        return this.managementNodes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("masterNodeId", (Object)this.masterNodeId).add("nodes", this.managementNodes.keySet()).toString();
    }

    public String toVerboseString() {
        return this.toString();
    }

    public static class Builder {
        protected String planeId;
        protected String masterNodeId;
        protected final Map<String, ManagementNodeSyncRecord> nodes = MutableMap.of();

        public Builder planeId(String val) {
            this.planeId = val;
            return this;
        }

        public Builder masterNodeId(String val) {
            this.masterNodeId = val;
            return this;
        }

        public Builder nodes(Iterable<ManagementNodeSyncRecord> vals) {
            Preconditions.checkState((!Iterables.contains((Iterable)((Iterable)Preconditions.checkNotNull(vals, (Object)"nodes must not be null")), null) ? 1 : 0) != 0, (String)"nodes must not contain null: %s", (Object[])new Object[]{vals});
            for (ManagementNodeSyncRecord val : vals) {
                this.nodes.put(val.getNodeId(), val);
            }
            return this;
        }

        public Builder node(ManagementNodeSyncRecord val) {
            Preconditions.checkNotNull((Object)val, (Object)"node must not be null");
            this.nodes.put(val.getNodeId(), val);
            return this;
        }

        public ManagementPlaneSyncRecord build() {
            return new ManagementPlaneSyncRecordImpl(this);
        }
    }
}

