/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.mutex;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class SemaphoreWithOwners
extends Semaphore {
    private static final long serialVersionUID = -5303474637353009454L;
    private final List<Thread> owningThreads = new ArrayList<Thread>();
    private final Set<Thread> requestingThreads = new LinkedHashSet<Thread>();
    private final String name;
    private String description;

    public SemaphoreWithOwners(String name) {
        this(name, 1, true);
    }

    public SemaphoreWithOwners(String name, int permits, boolean fair) {
        super(permits, fair);
        this.name = name;
    }

    @Override
    public void acquire() throws InterruptedException {
        try {
            this.onRequesting();
            super.acquire();
            this.onAcquired(1);
        }
        finally {
            this.onRequestFinished();
        }
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        try {
            this.onRequesting();
            super.acquire(permits);
            this.onAcquired(permits);
        }
        finally {
            this.onRequestFinished();
        }
    }

    @Override
    public void acquireUninterruptibly() {
        try {
            this.onRequesting();
            super.acquireUninterruptibly();
            this.onAcquired(1);
        }
        finally {
            this.onRequestFinished();
        }
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        try {
            this.onRequesting();
            super.acquireUninterruptibly(permits);
            this.onAcquired(permits);
        }
        finally {
            this.onRequestFinished();
        }
    }

    public void acquireUnchecked() {
        try {
            this.acquire();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void acquireUnchecked(int numPermits) {
        try {
            this.acquire(numPermits);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public boolean tryAcquire() {
        try {
            this.onRequesting();
            if (super.tryAcquire()) {
                this.onAcquired(1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.onRequestFinished();
        }
    }

    @Override
    public boolean tryAcquire(int permits) {
        try {
            this.onRequesting();
            if (super.tryAcquire(permits)) {
                this.onAcquired(permits);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.onRequestFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.onRequesting();
            if (super.tryAcquire(permits, timeout, unit)) {
                this.onAcquired(permits);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.onRequestFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.onRequesting();
            if (super.tryAcquire(timeout, unit)) {
                this.onAcquired(1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.onRequestFinished();
        }
    }

    protected synchronized void onAcquired(int permits) {
        for (int i = 0; i < permits; ++i) {
            this.owningThreads.add(Thread.currentThread());
        }
    }

    protected synchronized void onRequesting() {
        this.requestingThreads.add(Thread.currentThread());
    }

    protected synchronized void onRequestFinished() {
        this.requestingThreads.remove(Thread.currentThread());
    }

    @Override
    public void release() {
        super.release();
        this.onReleased(1);
    }

    @Override
    public void release(int permits) {
        super.release(permits);
        this.onReleased(permits);
    }

    protected synchronized void onReleased(int permits) {
        boolean result = true;
        for (int i = 0; i < permits; ++i) {
            result = this.owningThreads.remove(Thread.currentThread()) & result;
        }
        if (!result) {
            throw new IllegalStateException("Thread " + Thread.currentThread() + " which released " + this + " did not own it.");
        }
    }

    public synchronized boolean isInUse() {
        return !this.owningThreads.isEmpty() || !this.requestingThreads.isEmpty();
    }

    public synchronized boolean isCallingThreadAnOwner() {
        return this.owningThreads.contains(Thread.currentThread());
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized List<Thread> getOwningThreads() {
        return ImmutableList.copyOf(this.owningThreads);
    }

    public synchronized List<Thread> getRequestingThreads() {
        return ImmutableList.copyOf(this.requestingThreads);
    }

    @Override
    public synchronized String toString() {
        return super.toString() + "[" + this.name + "; description=" + this.description + "; owning=" + this.owningThreads + "; requesting=" + this.requestingThreads + "]";
    }

    public void indicateCallingThreadWillRequest() {
        this.requestingThreads.add(Thread.currentThread());
    }
}

