/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.system;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.text.Strings;

public class ProcessTaskStub {
    protected final List<String> commands = new ArrayList<String>();
    protected SshMachineLocation machine;
    protected String summary;
    protected final ConfigBag config = ConfigBag.newInstance();
    protected Function<ProcessTaskWrapper<?>, ?> returnResultTransformation = null;
    protected ScriptReturnType returnType = ScriptReturnType.EXIT_CODE;
    protected Boolean runAsScript = null;
    protected boolean runAsRoot = false;
    protected Boolean requireExitCodeZero = null;
    protected String extraErrorMessage = null;
    protected Map<String, String> shellEnvironment = new MutableMap();
    protected final List<Function<ProcessTaskWrapper<?>, Void>> completionListeners = new ArrayList();

    public ProcessTaskStub() {
    }

    protected ProcessTaskStub(ProcessTaskStub source) {
        this.commands.addAll(source.getCommands());
        this.machine = source.getMachine();
        this.summary = source.getSummary();
        this.config.copy(source.getConfig());
        this.returnResultTransformation = source.returnResultTransformation;
        this.returnType = source.returnType;
        this.runAsScript = source.runAsScript;
        this.runAsRoot = source.runAsRoot;
        this.requireExitCodeZero = source.requireExitCodeZero;
        this.extraErrorMessage = source.extraErrorMessage;
        this.shellEnvironment.putAll(source.getShellEnvironment());
        this.completionListeners.addAll(source.getCompletionListeners());
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return Strings.maxlen((String)Strings.join(this.commands, (String)" ; "), (int)160);
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public Map<String, String> getShellEnvironment() {
        return ImmutableMap.copyOf(this.shellEnvironment);
    }

    public String toString() {
        return super.toString() + "[" + this.getSummary() + "]";
    }

    public List<String> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }

    public List<Function<ProcessTaskWrapper<?>, Void>> getCompletionListeners() {
        return this.completionListeners;
    }

    protected ConfigBag getConfig() {
        return this.config;
    }

    public static enum ScriptReturnType {
        CUSTOM,
        EXIT_CODE,
        STDOUT_STRING,
        STDOUT_BYTES,
        STDERR_STRING,
        STDERR_BYTES;

    }
}

