/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Address;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.AddressCreationOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/addresses")
@Consumes(value={"application/json"})
public interface AddressApi {
    @Named(value="Addresses:get")
    @GET
    @Path(value="/{address}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Address get(@PathParam(value="address") String var1);

    @Named(value="Addresses:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation create(@PayloadParam(value="name") String var1);

    @Named(value="Addresses:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) AddressCreationOptions var1);

    @Named(value="Addresses:delete")
    @DELETE
    @Path(value="/{address}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="address") String var1);

    @Named(value="Addresses:list")
    @GET
    public ListPage<Address> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Addresses:list")
    @GET
    @Transform(value=AddressPages.class)
    public Iterator<ListPage<Address>> list();

    @Named(value="Addresses:list")
    @GET
    @Transform(value=AddressPages.class)
    public Iterator<ListPage<Address>> list(ListOptions var1);

    public static final class AddressPages
    extends BaseCallerArg0ToIteratorOfListPage<Address, AddressPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        AddressPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Address>> fetchNextPage(final String regionName, final ListOptions options) {
            return new Function<String, ListPage<Address>>(){

                public ListPage<Address> apply(String pageToken) {
                    return AddressPages.this.api.addressesInRegion(regionName).listPage(pageToken, options);
                }
            };
        }
    }
}

