/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.persistentmap;

import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.lang.reflect.Type;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMap<V>
extends AbstractMap<String, V>
implements Closeable {
    static final JSONCodec codec = new JSONCodec();
    final File dir;
    final File data;
    final RandomAccessFile lockFile;
    final Map<String, SoftReference<V>> cache = new HashMap<String, SoftReference<V>>();
    boolean inited = false;
    boolean closed = false;
    Type type;

    public PersistentMap(File dir, Type type) throws IOException {
        this.dir = dir;
        this.type = type;
        dir.mkdirs();
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("PersistentMap cannot create directory " + dir);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("PersistentMap cannot write directory " + dir);
        }
        File f = new File(dir, "lock");
        this.lockFile = new RandomAccessFile(f, "rw");
        FileChannel channel = this.lockFile.getChannel();
        FileLock lock = channel.lock();
        if (!lock.isValid()) {
            throw new IllegalArgumentException("PersistentMap cannot lock dir " + dir);
        }
        this.data = new File(dir, "data").getAbsoluteFile();
        this.data.mkdir();
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("PersistentMap cannot create data directory " + dir);
        }
        if (!this.data.canWrite()) {
            throw new IllegalArgumentException("PersistentMap cannot write data directory " + this.data);
        }
    }

    public PersistentMap(File dir, Class<V> type) throws IOException {
        this(dir, (Type)type);
    }

    public PersistentMap(File dir, Class<V> type, Map<String, V> map) throws IOException {
        this(dir, (Type)type);
        this.putAll(map);
    }

    public PersistentMap(File dir, Type type, Map<String, V> map) throws IOException {
        this(dir, type);
        this.putAll(map);
    }

    void init() {
        if (this.inited) {
            return;
        }
        if (this.closed) {
            throw new IllegalStateException("PersistentMap " + this.dir + " is already closed");
        }
        this.inited = true;
        for (File file : this.data.listFiles()) {
            this.cache.put(file.getName(), null);
        }
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            public int size() {
                PersistentMap.this.init();
                return PersistentMap.this.cache.size();
            }

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                PersistentMap.this.init();
                return new Iterator<Map.Entry<String, V>>(){
                    Iterator<Map.Entry<String, SoftReference<V>>> it;
                    Map.Entry<String, SoftReference<V>> entry;
                    {
                        this.it = PersistentMap.this.cache.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        try {
                            this.entry = this.it.next();
                            SoftReference ref = this.entry.getValue();
                            Object value = null;
                            if (ref != null) {
                                value = ref.get();
                            }
                            if (value == null) {
                                File file = new File(PersistentMap.this.data, this.entry.getKey());
                                value = codec.dec().from(file).get(PersistentMap.this.type);
                                this.entry.setValue(new SoftReference<Object>(value));
                            }
                            final Object v = value;
                            return new Map.Entry<String, V>(){

                                @Override
                                public String getKey() {
                                    return entry.getKey();
                                }

                                @Override
                                public V getValue() {
                                    return v;
                                }

                                @Override
                                public V setValue(V value) {
                                    return PersistentMap.this.put(entry.getKey(), value);
                                }
                            };
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        PersistentMap.this.remove(this.entry.getKey());
                    }
                };
            }
        };
    }

    @Override
    public V put(String key, V value) {
        this.init();
        try {
            V old = null;
            SoftReference<V> ref = this.cache.get(key);
            if (ref != null) {
                old = ref.get();
            }
            File file = new File(this.data, key);
            codec.enc().to(file).put(value);
            this.cache.put(key, new SoftReference<V>(value));
            return old;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public V remove(String key) {
        this.init();
        File file = new File(this.data, key);
        file.delete();
        if (file.exists()) {
            throw new IllegalStateException("PersistentMap cannot delete entry " + file);
        }
        return this.cache.remove(key).get();
    }

    @Override
    public void clear() {
        this.init();
        try {
            IO.deleteWithException(this.data);
            this.cache.clear();
            this.data.mkdir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        this.init();
        return this.cache.keySet();
    }

    @Override
    public void close() throws IOException {
        this.lockFile.close();
        this.closed = true;
        this.inited = false;
    }

    @Override
    public String toString() {
        return "PersistentMap[" + this.dir + "] " + super.toString();
    }
}

