/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.objs.BasicConfigurableObject;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJcloudsLocationCustomizer
extends BasicConfigurableObject
implements JcloudsLocationCustomizer,
EntityInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(BasicJcloudsLocationCustomizer.class);

    public BasicJcloudsLocationCustomizer() {
        this((Map<?, ?>)ImmutableMap.of());
    }

    public BasicJcloudsLocationCustomizer(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    public BasicJcloudsLocationCustomizer(ConfigBag params) {
        for (Map.Entry entry : params.getAllConfig().entrySet()) {
            this.config().set(ConfigKeys.newConfigKey(Object.class, (String)((String)entry.getKey())), entry.getValue());
        }
    }

    public void apply(EntityLocal entity) {
        Object merged;
        ConfigKey subkey = BrooklynConfigKeys.PROVISIONING_PROPERTIES.subKey(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS.getName());
        ConfigBag provisioningProperties = ConfigBag.newInstance((Map)((Map)entity.config().get((ConfigKey)BrooklynConfigKeys.PROVISIONING_PROPERTIES)));
        Collection existingCustomizers = (Collection)provisioningProperties.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS);
        if (existingCustomizers == null) {
            merged = ImmutableList.of((Object)this);
        } else {
            merged = Lists.newArrayListWithCapacity((int)(1 + existingCustomizers.size()));
            merged.addAll(existingCustomizers);
            merged.add(this);
        }
        LOG.debug("{} set location customizers on {}: {}", new Object[]{this, entity, Iterables.toString((Iterable)merged)});
        entity.config().set(subkey, merged);
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateBuilder templateBuilder) {
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, Template template) {
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateOptions templateOptions) {
    }

    @Override
    public void customize(JcloudsLocation location, NodeMetadata node, ConfigBag setup) {
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
    }

    @Override
    public void preRelease(JcloudsMachineLocation machine) {
    }

    @Override
    public void postRelease(JcloudsMachineLocation machine) {
    }

    @Override
    public void preReleaseOnObtainError(JcloudsLocation jcloudsLocation, @Nullable JcloudsMachineLocation machineLocation, Exception cause) {
    }

    @Override
    public void postReleaseOnObtainError(JcloudsLocation jcloudsLocation, @Nullable JcloudsMachineLocation machineLocation, Exception cause) {
    }

    protected Entity getCallerContext(JcloudsMachineLocation machine) {
        Object context = this.config().get(LocationConfigKeys.CALLER_CONTEXT);
        if (context == null) {
            context = machine.config().get(LocationConfigKeys.CALLER_CONTEXT);
        }
        if (!(context instanceof Entity)) {
            throw new IllegalStateException("Invalid location context: " + context);
        }
        return (Entity)context;
    }
}

