/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private VisitableBuilder<? extends IngressBackend, ?> backend;
    private List<VisitableBuilder<? extends IngressRule, ?>> rules = new ArrayList();
    private List<VisitableBuilder<? extends IngressTLS, ?>> tls = new ArrayList();

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
    }

    @Override
    public IngressBackend getBackend() {
        return this.backend != null ? (IngressBackend)this.backend.build() : null;
    }

    @Override
    public A withBackend(IngressBackend backend) {
        this._visitables.remove(this.backend);
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.add(this.backend);
        }
        return (A)this;
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public A addToRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<IngressRule> getRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public A withRules(List<IngressRule> rules) {
        this._visitables.removeAll(this.rules);
        this.rules.clear();
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRules(IngressRule ... rules) {
        this.rules.clear();
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(item);
    }

    @Override
    public A addToTls(IngressTLS ... items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTls(IngressTLS ... items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.remove(builder);
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<IngressTLS> getTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public A withTls(List<IngressTLS> tls) {
        this._visitables.removeAll(this.tls);
        this.tls.clear();
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTls(IngressTLS ... tls) {
        this.tls.clear();
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item) {
        return new TlsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public class TlsNestedImpl<N>
    extends IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>>
    implements IngressSpecFluent.TlsNested<N>,
    Nested<N> {
        private final IngressTLSBuilder builder;

        TlsNestedImpl(IngressTLS item) {
            this.builder = new IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new IngressTLSBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.addToTls(this.builder.build());
        }

        @Override
        public N endTl() {
            return this.and();
        }
    }

    public class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>>
    implements IngressSpecFluent.RulesNested<N>,
    Nested<N> {
        private final IngressRuleBuilder builder;

        RulesNestedImpl(IngressRule item) {
            this.builder = new IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.builder = new IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.addToRules(this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>>
    implements IngressSpecFluent.BackendNested<N>,
    Nested<N> {
        private final IngressBackendBuilder builder;

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

