/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.derived;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;

public final class ZoneIdToURIFromJoinOnRegionIdToURI
implements ZoneIdToURISupplier {
    private final Supplier<Map<String, Supplier<URI>>> regionIdToURIs;
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIds;

    @Inject
    ZoneIdToURIFromJoinOnRegionIdToURI(@Region Supplier<Map<String, Supplier<URI>>> regionIdToURIs, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIds) {
        this.regionIdToURIs = regionIdToURIs;
        this.regionIdToZoneIds = regionIdToZoneIds;
    }

    public Map<String, Supplier<URI>> get() {
        Map regionIdToZoneIds = (Map)this.regionIdToZoneIds.get();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry regionToURI : ((Map)this.regionIdToURIs.get()).entrySet()) {
            Supplier zoneIds = (Supplier)regionIdToZoneIds.get(regionToURI.getKey());
            Preconditions.checkState((zoneIds != null ? 1 : 0) != 0, (String)"region %s is not in the configured region to zone mappings: %s", (Object[])new Object[]{regionToURI.getKey(), regionIdToZoneIds});
            for (String zone : (Set)zoneIds.get()) {
                builder.put((Object)zone, regionToURI.getValue());
            }
        }
        return builder.build();
    }
}

