/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.AbortError;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestEffector;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEffectorImpl
extends TargetableTestComponentImpl
implements TestEffector {
    private static final Logger LOG = LoggerFactory.getLogger(TestEffectorImpl.class);

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            Entity targetEntity = this.resolveTarget();
            String effectorName = (String)this.getRequiredConfig(EFFECTOR_NAME);
            Map effectorParams = (Map)this.getConfig(EFFECTOR_PARAMS);
            Duration timeout = (Duration)this.getConfig(TIMEOUT);
            Integer maxAttempts = (Integer)this.getConfig(MAX_ATTEMPTS);
            Duration backoffToPeriod = (Duration)this.getConfig(BACKOFF_TO_PERIOD);
            if (!this.getChildren().isEmpty()) {
                throw new RuntimeException(String.format("The entity [%s] cannot have child entities", this.getClass().getName()));
            }
            Maybe effector = EffectorUtils.findEffectorDeclared((Entity)targetEntity, (String)effectorName);
            if (effector.isAbsentOrNull()) {
                throw new AssertionError((Object)String.format("No effector with name [%s]", effectorName));
            }
            Object effectorResult = this.invokeEffector(targetEntity, (Effector)effector.get(), effectorParams, maxAttempts, timeout, backoffToPeriod);
            List<Map<String, Object>> assertions = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERTIONS);
            if (assertions != null && !assertions.isEmpty()) {
                Supplier supplier = Suppliers.ofInstance((Object)effectorResult);
                TestFrameworkAssertions.checkAssertionsEventually(new TestFrameworkAssertions.AssertionOptions(effectorName, supplier).maxAttempts(1).timeout(timeout).assertions(assertions));
            }
            this.sensors().set((AttributeSensor)EFFECTOR_RESULT, effectorResult);
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void stop() {
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    protected Object invokeEffector(final Entity targetEntity, final Effector<?> effector, final Map<String, ?> effectorParams, Integer maxAttempts, final Duration timeout, Duration backoffToPeriod) {
        Duration timeLimit = timeout != null ? timeout : (maxAttempts == null ? Asserts.DEFAULT_LONG_TIMEOUT : Duration.PRACTICALLY_FOREVER);
        int iterationLimit = maxAttempts != null ? maxAttempts : 1;
        final Long startTime = System.currentTimeMillis();
        final AtomicReference effectorResult = new AtomicReference();
        Repeater.create().until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws ExecutionException {
                try {
                    long timeRemaining = Time.timeRemaining((long)startTime, (long)timeout.toMilliseconds());
                    Object result = TestEffectorImpl.this.invokeEffector(targetEntity, effector, effectorParams, Duration.millis((Number)timeRemaining));
                    effectorResult.set(result);
                    return true;
                }
                catch (TimeoutException e) {
                    throw new AssertionError("Effector " + effector.getName() + " timed out after " + timeout, e);
                }
            }
        }).limitIterationsTo(iterationLimit).limitTimeTo(timeLimit).backoffTo(backoffToPeriod).rethrowExceptionImmediately(Predicates.or((Iterable)ImmutableList.of((Object)Predicates.instanceOf(TimeoutException.class), (Object)Predicates.instanceOf(AbortError.class), (Object)Predicates.instanceOf(InterruptedException.class), (Object)Predicates.instanceOf(RuntimeInterruptedException.class)))).runRequiringTrue();
        return effectorResult.get();
    }

    protected Object invokeEffector(Entity targetEntity, Effector<?> effector, Map<String, ?> effectorParams, Duration timeout) throws ExecutionException, TimeoutException {
        Task task = effectorParams == null || effectorParams.isEmpty() ? Entities.invokeEffector((Entity)this, (Entity)targetEntity, effector) : Entities.invokeEffector((Entity)this, (Entity)targetEntity, effector, effectorParams);
        try {
            return task.get(timeout);
        }
        catch (InterruptedException e) {
            task.cancel(true);
            throw Exceptions.propagate((Throwable)e);
        }
        catch (TimeoutException e) {
            task.cancel(true);
            throw e;
        }
    }
}

