/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.ArchiveTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;

public class SaltSshTasks {
    private static final String UTILITY_SCRIPT = "salt_utilities.sh";

    private SaltSshTasks() {
    }

    public static TaskFactory<?> installSalt(boolean force) {
        return SaltSshTasks.sshCommands(BashCommands.commandToDownloadUrlAs((String)"https://bootstrap.saltstack.com", (String)"install_salt.sh"), BashCommands.sudo((String)"sh install_salt.sh")).summary("install salt");
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> isSaltInstalled(boolean force) {
        return (SshEffectorTasks.SshEffectorTaskFactory)SaltSshTasks.invokeSaltUtility("salt_installed", null, true).summary("check installed");
    }

    public static TaskFactory<?> configureForMasterlessOperation(boolean force) {
        return SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudo((String)"sed -i '/^#file_client/c file_client: local' /etc/salt/minion")}).summary("configure masterless");
    }

    public static TaskFactory<?> enableFileRoots(boolean force) {
        return ((SshEffectorTasks.SshEffectorTaskFactory)SaltSshTasks.sshCommands("grep ^file_roots /etc/salt/minion || {", "cat /etc/salt/minion > /tmp/minion.update", "cat >> /tmp/minion.update  << BROOKLYN_EOF", "file_roots:", "  base:", "    - /srv/salt/", "BROOKLYN_EOF", BashCommands.sudo((String)"mv /tmp/minion.update /etc/salt/minion"), "}").requiringExitCodeZero()).summary("enable file_roots");
    }

    public static TaskFactory<?> addPillarToTop(String pillar, boolean b) {
        return SaltSshTasks.invokeSaltUtility("add_pillar_to_top", pillar, false).summary("Add pillar " + pillar + " to top");
    }

    public static TaskFactory<?> installSaltPillar(final String pillarUrl, boolean force) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                TaskBuilder tb = Tasks.builder().displayName(pillarUrl);
                String tempDownloadDir = "/tmp/download-" + Identifiers.makeRandomId((int)12);
                tb.add(ArchiveTasks.deploy(null, null, (String)pillarUrl, (SshMachineLocation)EffectorTasks.findSshMachine(), (String)tempDownloadDir, (boolean)false, null, null).newTask());
                tb.add((TaskAdaptable)SshEffectorTasks.ssh((String[])new String[]{"cd " + tempDownloadDir + " ; " + BashCommands.sudo((String)"mv * /srv/pillar")}).newTask());
                return tb.build();
            }
        };
    }

    public static TaskFactory<?> installSaltFormula(final String formulaUrl, boolean force) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                TaskBuilder tb = Tasks.builder().displayName(formulaUrl);
                String tempDirectoryForUnpack = "/tmp/download-" + Identifiers.makeRandomId((int)12);
                tb.add(ArchiveTasks.deploy(null, null, (String)formulaUrl, (SshMachineLocation)EffectorTasks.findSshMachine(), (String)tempDirectoryForUnpack, (boolean)false, null, null).newTask());
                String installCmd = BashCommands.chain((String[])new String[]{"cd " + tempDirectoryForUnpack, "EXPANDED_DIR=`ls`", BashCommands.requireTest((String)"`ls | wc -w` -eq 1", (String)("The deployed archive " + formulaUrl + " must contain exactly one directory")), "sudo mkdir -p /srv/formula", "sudo mv $EXPANDED_DIR /srv/formula/", "sudo sed -i \"$ a\\    - /srv/formula/$EXPANDED_DIR\" /etc/salt/minion", "cd ..", "rm -rf '" + tempDirectoryForUnpack + "'"});
                tb.add((TaskAdaptable)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{installCmd}).summary("installing " + formulaUrl + " states to /srv/formula")).requiringExitCodeZero()).newTask());
                return tb.build();
            }
        };
    }

    public static TaskFactory<?> installTopFile(Set<? extends String> runList, boolean force) {
        MutableList.Builder topBuilder = MutableList.builder().add((Object)"cat > /tmp/top.sls << BROOKLYN_EOF").add((Object)"base:").add((Object)"  '*':");
        for (String string : runList) {
            topBuilder.add((Object)("    - " + string));
        }
        topBuilder.add((Object)"BROOKLYN_EOF");
        MutableList createTempTopFile = topBuilder.build();
        MutableList mutableList = MutableList.builder().add((Object)BashCommands.sudo((String)"mkdir -p /srv/salt")).add((Object)Strings.join((Iterable)createTempTopFile, (String)"\n")).add((Object)BashCommands.sudo((String)"mv /tmp/top.sls /srv/salt")).build();
        return SshEffectorTasks.ssh((List)mutableList).summary("create top.sls file");
    }

    public static ProcessTaskFactory<Integer> applyTopStates(boolean force) {
        return SaltSshTasks.saltCall("state.apply");
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> applyState(String state, boolean force) {
        return SaltSshTasks.saltCall("state.apply " + state);
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> saltCall(String command) {
        return (SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudo((String)("salt-call --local " + command))}).allowingNonZeroExitCode();
    }

    public static ProcessTaskWrapper<String> retrieveHighstate() {
        return ((SshEffectorTasks.SshEffectorTaskFactory)SaltSshTasks.saltCall("state.show_highstate --out=yaml").summary("retrieve highstate")).requiringZeroAndReturningStdout().newTask();
    }

    public static TaskFactory<?> installSaltUtilities(boolean force) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                TaskBuilder builder = Tasks.builder().displayName("install salt utilities").add((TaskAdaptable)SaltSshTasks.installScript(SaltSshTasks.UTILITY_SCRIPT, "install salt shell utils").newTask()).add((TaskAdaptable)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudo((String)"mv /tmp/salt_utilities.sh /etc/salt")}).newTask());
                return builder.build();
            }
        };
    }

    private static SshPutTaskFactory installScript(String name, String description) {
        return SshEffectorTasks.put((String)("/tmp/" + name)).contents(ResourceUtils.create().getResourceFromUrl("classpath:" + name)).summary(description);
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> verifyStates(Set<String> states, boolean force) {
        return SaltSshTasks.invokeSaltUtility("verify_states", Strings.join(states, (String)" "), true);
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> findStates(Set<String> states, boolean force) {
        return SaltSshTasks.invokeSaltUtility("find_states", Strings.join(states, (String)" "), true);
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> invokeSaltUtility(String functionName, String args, boolean permitFailure) {
        SshEffectorTasks.SshEffectorTaskFactory taskFactory = (SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudo((String)("/bin/bash -c '. /etc/salt/salt_utilities.sh ; " + functionName + " " + args + "'"))}).summary(functionName);
        if (permitFailure) {
            taskFactory.allowingNonZeroExitCode();
        } else {
            taskFactory.requiringExitCodeZero();
        }
        return taskFactory;
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> sshCommands(String line, String ... lines) {
        MutableList.Builder builder = MutableList.builder().add((Object)line);
        builder.addAll((Object[])lines);
        return SshEffectorTasks.ssh((String[])new String[]{Strings.join((Iterable)builder.build(), (String)"\n")});
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> setMinionId(String entityId) {
        return SaltSshTasks.invokeSaltUtility("set_minion_id", entityId, true);
    }
}

