/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.test.framework.TestSshCommand;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSshCommandImpl
extends TargetableTestComponentImpl
implements TestSshCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TestSshCommandImpl.class);
    private static final int A_LINE = 80;
    private static final String DEFAULT_NAME = "download.sh";
    private static final String CD = "cd";

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        this.execute();
    }

    public void stop() {
        LOG.debug("{} Stopping simple command", (Object)this);
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        LOG.debug("{} Restarting simple command", (Object)this);
        this.execute();
    }

    private String shorten(String text) {
        return Strings.maxlenWithEllipsis((String)text, (int)80);
    }

    public void execute() {
        try {
            this.checkConfig();
            final SshMachineLocation machineLocation = (SshMachineLocation)Machines.findUniqueMachineLocation((Iterable)this.resolveTarget().getLocations(), SshMachineLocation.class).get();
            Duration timeout = (Duration)this.getRequiredConfig(TIMEOUT);
            Integer maxAttempts = (Integer)this.getConfig(MAX_ATTEMPTS);
            Duration backoffToPeriod = (Duration)this.getRequiredConfig(BACKOFF_TO_PERIOD);
            ReferenceWithError result = Repeater.create((String)"Running ssh-command tests").limitTimeTo(timeout).limitIterationsTo(maxAttempts != null ? maxAttempts : Integer.MAX_VALUE).backoffTo(backoffToPeriod != null ? backoffToPeriod : Duration.millis((Number)500)).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        Result result = TestSshCommandImpl.this.executeCommand(machineLocation);
                        TestSshCommandImpl.this.handle(result);
                    }
                    catch (AssertionError e) {
                        throw new MarkerException((Throwable)((Object)e));
                    }
                    return true;
                }
            }).runKeepingError();
            if (result.hasError()) {
                this.setUpAndRunState(false, Lifecycle.ON_FIRE);
                Throwable error = result.getError();
                if (error instanceof MarkerException) {
                    error = error.getCause();
                }
                throw Exceptions.propagate((Throwable)error);
            }
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private Result executeCommand(SshMachineLocation machineLocation) {
        Result result = null;
        String downloadUrl = (String)this.getConfig((ConfigKey.HasConfigKey)DOWNLOAD_URL);
        String command = (String)this.getConfig(COMMAND);
        ShellEnvironmentSerializer envSerializer = new ShellEnvironmentSerializer(this.getManagementContext());
        Map env = envSerializer.serialize((Map)this.getConfig(SHELL_ENVIRONMENT));
        if (env == null) {
            env = ImmutableMap.of();
        }
        if (Strings.isNonBlank((CharSequence)downloadUrl)) {
            String scriptDir = (String)this.getConfig(SCRIPT_DIR);
            String scriptPath = this.calculateDestPath(downloadUrl, scriptDir);
            result = this.executeDownloadedScript(machineLocation, downloadUrl, scriptPath, env);
        } else if (Strings.isNonBlank((CharSequence)command)) {
            result = this.executeShellCommand(machineLocation, command, env);
        } else {
            throw this.illegal("Must specify exactly one of", DOWNLOAD_URL.getName(), "and", COMMAND.getName());
        }
        return result;
    }

    protected void checkConfig() {
        String downloadUrl = (String)this.getConfig((ConfigKey.HasConfigKey)DOWNLOAD_URL);
        String command = (String)this.getConfig(COMMAND);
        if (!(Strings.isNonBlank((CharSequence)downloadUrl) ^ Strings.isNonBlank((CharSequence)command))) {
            String downloadName = DOWNLOAD_URL.getName();
            String commandName = COMMAND.getName();
            throw this.illegal("Must specify exactly one of", downloadName, "and", commandName);
        }
    }

    protected void handle(Result result) {
        LOG.debug("{}, Result is {}\nwith output [\n{}\n] and error [\n{}\n]", new Object[]{this, result.getExitCode(), this.shorten(result.getStdout()), this.shorten(result.getStderr())});
        TestFrameworkAssertions.AssertionSupport support = new TestFrameworkAssertions.AssertionSupport();
        for (Map<String, Object> assertion : this.exitCodeAssertions()) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "exit code", result.getExitCode());
        }
        for (Map<String, Object> assertion : TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_OUT)) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "stdout", result.getStdout());
        }
        for (Map<String, Object> assertion : TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_ERR)) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "stderr", result.getStderr());
        }
        support.validate();
    }

    private Result executeDownloadedScript(SshMachineLocation machineLocation, String url, String scriptPath, Map<String, String> env) {
        TaskFactory install = SshTasks.installFromUrl((Map)ImmutableMap.of(), (SshMachineLocation)machineLocation, (String)url, (String)scriptPath);
        DynamicTasks.queue((TaskFactory)install);
        DynamicTasks.waitForLast();
        ImmutableList commands = ImmutableList.builder().add((Object)("chmod u+x " + scriptPath)).addAll(this.maybeCdToRunDirCmd()).add((Object)scriptPath).build();
        return this.runCommands(machineLocation, (List<String>)commands, env);
    }

    private Result executeShellCommand(SshMachineLocation machineLocation, String command, Map<String, String> env) {
        ImmutableList commands = ImmutableList.builder().addAll(this.maybeCdToRunDirCmd()).add((Object)command).build();
        return this.runCommands(machineLocation, (List<String>)commands, env);
    }

    private List<String> maybeCdToRunDirCmd() {
        String runDir = (String)this.getConfig(RUN_DIR);
        if (!Strings.isBlank((CharSequence)runDir)) {
            return ImmutableList.of((Object)("cd " + runDir));
        }
        return ImmutableList.of();
    }

    private Result runCommands(SshMachineLocation machine, List<String> commands, Map<String, String> env) {
        SshEffectorTasks.SshEffectorTaskFactory etf = (SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])commands.toArray(new String[0])).environmentVariables(env)).machine((MachineLocation)machine);
        ProcessTaskWrapper job = (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)etf);
        job.asTask().blockUntilEnded();
        return new Result((ProcessTaskWrapper<Integer>)job);
    }

    private IllegalArgumentException illegal(String message, String ... messages) {
        Iterable allmsgs = Iterables.concat((Iterable)MutableList.of((Object)(this.toString() + ":"), (Object)message), Arrays.asList(messages));
        return new IllegalArgumentException(Joiner.on((char)' ').join(allmsgs));
    }

    private String calculateDestPath(String url, String directory) {
        try {
            URL asUrl = new URL(url);
            Iterable path = Splitter.on((String)"/").split((CharSequence)asUrl.getPath());
            String scriptName = TestSshCommandImpl.getLastPartOfPath(path, DEFAULT_NAME);
            return Joiner.on((String)"/").join((Object)directory, (Object)("test-" + Identifiers.makeRandomId((int)8)), new Object[]{scriptName});
        }
        catch (MalformedURLException e) {
            throw this.illegal("Malformed URL:", url);
        }
    }

    private static String getLastPartOfPath(Iterable<String> path, String defaultName) {
        MutableList parts = MutableList.copyOf(path);
        Collections.reverse(parts);
        Iterator it = parts.iterator();
        String scriptName = null;
        while (Strings.isBlank(scriptName) && it.hasNext()) {
            scriptName = (String)it.next();
        }
        if (Strings.isBlank(scriptName)) {
            scriptName = defaultName;
        }
        return scriptName;
    }

    private List<Map<String, Object>> exitCodeAssertions() {
        MutableList result;
        MutableList assertStatus = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_STATUS);
        List<Map<String, Object>> assertOut = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_OUT);
        List<Map<String, Object>> assertErr = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_ERR);
        if (assertStatus.isEmpty() && assertOut.isEmpty() && assertErr.isEmpty()) {
            Map shouldSucceed = DEFAULT_ASSERTION;
            result = MutableList.of((Object)shouldSucceed);
        } else {
            result = assertStatus;
        }
        return result;
    }

    private static class MarkerException
    extends Exception {
        public MarkerException(Throwable cause) {
            super(cause);
        }
    }

    private static class Result {
        int exitCode;
        String stdout;
        String stderr;

        public Result(ProcessTaskWrapper<Integer> job) {
            this.exitCode = (Integer)job.get();
            this.stdout = job.getStdout().trim();
            this.stderr = job.getStderr().trim();
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }
    }
}

