/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.file;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.ArchiveBuilder;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.StackTraceSimplifier;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUtils.class);
    public static final int NUM_RETRIES_FOR_COPYING = 5;

    @Deprecated
    public static List<String> installCommands(String fileName) {
        return ArchiveUtils.installCommands(BashCommandsConfigurable.newInstance(), fileName);
    }

    public static List<String> installCommands(BashCommandsConfigurable bash, String fileName) {
        LinkedList<String> commands = new LinkedList<String>();
        switch (ArchiveType.of(fileName)) {
            case TAR: 
            case TGZ: 
            case TBZ: {
                commands.add(bash.INSTALL_TAR);
                break;
            }
            case ZIP: {
                commands.add(bash.INSTALL_UNZIP);
                break;
            }
        }
        return commands;
    }

    public static List<String> extractCommands(String fileName, String sourceDir, String targetDir, boolean extractJar) {
        return ArchiveUtils.extractCommands(fileName, sourceDir, targetDir, extractJar, true);
    }

    public static List<String> extractCommands(String fileName, String sourceDir, String targetDir, boolean extractJar, boolean keepOriginal) {
        LinkedList<String> commands = new LinkedList<String>();
        commands.add("cd " + targetDir);
        String sourcePath = Os.mergePathsUnix((String[])new String[]{sourceDir, fileName});
        switch (ArchiveType.of(fileName)) {
            case TAR: {
                commands.add("tar xvf " + sourcePath);
                break;
            }
            case TGZ: {
                commands.add("tar xvfz " + sourcePath);
                break;
            }
            case TBZ: {
                commands.add("tar xvfj " + sourcePath);
                break;
            }
            case ZIP: {
                commands.add("unzip " + sourcePath);
                break;
            }
            case JAR: 
            case WAR: 
            case EAR: {
                if (extractJar) {
                    commands.add("jar -xvf " + sourcePath);
                    break;
                }
            }
            case UNKNOWN: {
                if (!sourcePath.equals(Urls.mergePaths((String[])new String[]{targetDir, fileName}))) {
                    commands.add("cp " + sourcePath + " " + targetDir);
                    break;
                }
                keepOriginal = true;
            }
        }
        if (!keepOriginal && !commands.isEmpty()) {
            commands.add("rm " + sourcePath);
        }
        return commands;
    }

    public static List<String> extractCommands(String fileName, String sourceDir) {
        return ArchiveUtils.extractCommands(fileName, sourceDir, ".", false);
    }

    public static void deploy(String archiveUrl, SshMachineLocation machine, String destDir) {
        ArchiveUtils.deploy(MutableMap.of(), archiveUrl, machine, destDir);
    }

    public static void deploy(Map<String, ?> props, String archiveUrl, SshMachineLocation machine, String destDir) {
        MutableList filesToDelete = MutableList.of();
        if (Urls.isDirectory((String)archiveUrl)) {
            File zipFile = ArchiveBuilder.zip().entry(".", Urls.toFile((String)archiveUrl)).create();
            filesToDelete.add(zipFile);
            archiveUrl = zipFile.getAbsolutePath();
        }
        String destFile = archiveUrl.contains("?") ? archiveUrl.substring(0, archiveUrl.indexOf(63)) : archiveUrl;
        destFile = destFile.substring(destFile.lastIndexOf(47) + 1);
        ArchiveUtils.deploy(props, archiveUrl, machine, destDir, destFile);
        filesToDelete.forEach(f -> f.delete());
    }

    public static void deploy(String archiveUrl, SshMachineLocation machine, String destDir, String destFile) {
        ArchiveUtils.deploy(MutableMap.of(), archiveUrl, machine, destDir, destDir, destFile);
    }

    public static void deploy(Map<String, ?> props, String archiveUrl, SshMachineLocation machine, String destDir, String destFile) {
        ArchiveUtils.deploy(props, archiveUrl, machine, destDir, destDir, destFile);
    }

    public static void deploy(Map<String, ?> props, String archiveUrl, SshMachineLocation machine, String tmpDir, String destDir, String destFile) {
        ArchiveUtils.deploy(null, props, archiveUrl, machine, destDir, true, tmpDir, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deploy(ResourceUtils resolver, Map<String, ?> props, String archiveUrl, SshMachineLocation machine, String destDir, boolean keepArchiveAfterUnpacking, String optionalTmpDir, String optionalDestFile) {
        String destFile = optionalDestFile;
        if (destFile == null) {
            destFile = Urls.getBasename((String)((String)Preconditions.checkNotNull((Object)archiveUrl, (Object)"archiveUrl")));
        }
        if (Strings.isBlank((CharSequence)destFile)) {
            throw new IllegalStateException("Not given filename and cannot infer archive type from '" + archiveUrl + "'");
        }
        String tmpDir = optionalTmpDir;
        if (tmpDir == null) {
            tmpDir = (String)Preconditions.checkNotNull((Object)destDir, (Object)"destDir");
        }
        if (props == null) {
            props = MutableMap.of();
        }
        String destPath = Os.mergePaths((String[])new String[]{tmpDir, destFile});
        machine.acquireMutex("installing", "installing archive");
        try {
            int result = ArchiveUtils.install(resolver, props, machine, archiveUrl, destPath, 5);
            if (result != 0) {
                throw new IllegalStateException(String.format("Unable to install archive %s to %s", archiveUrl, machine));
            }
            MutableList commands = MutableList.copyOf(ArchiveUtils.installCommands(BrooklynOsCommands.bash(machine), destFile)).appendAll(ArchiveUtils.extractCommands(destFile, tmpDir, destDir, false, keepArchiveAfterUnpacking));
            result = DynamicTasks.getTaskQueuingContext() != null ? ((Integer)((ProcessTaskWrapper)DynamicTasks.queue(SshTasks.newSshExecTaskFactory(machine, (String[])commands.toArray((Object[])new String[0])).summary("extracting archive").requiringExitCodeZero())).get()).intValue() : machine.execCommands((Map<String, ?>)props, "extracting content", (List<String>)commands);
            if (result != 0) {
                throw new IllegalStateException(String.format("Failed to expand archive %s on %s", archiveUrl, machine));
            }
            boolean bl = ArchiveType.of(destFile) != ArchiveType.UNKNOWN;
            return bl;
        }
        finally {
            machine.releaseMutex("installing");
        }
    }

    public static int install(SshMachineLocation machine, String urlToInstall, String target) {
        return ArchiveUtils.install(MutableMap.of(), machine, urlToInstall, target, 5);
    }

    public static int install(Map<String, ?> props, SshMachineLocation machine, String urlToInstall, String target, int numAttempts) {
        return ArchiveUtils.install(null, props, machine, urlToInstall, target, numAttempts);
    }

    public static int install(ResourceUtils resolver, Map<String, ?> props, SshMachineLocation machine, String urlToInstall, String target, int numAttempts) {
        if (resolver == null) {
            resolver = ResourceUtils.create(machine);
        }
        Exception lastError = null;
        int retriesRemaining = numAttempts;
        int attemptNum = 0;
        do {
            ++attemptNum;
            try {
                Tasks.setBlockingDetails("Installing " + urlToInstall + " at " + machine);
                int n = machine.installTo(resolver, props, urlToInstall, target);
                return n;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                lastError = e;
                String stack = StackTraceSimplifier.toString((Throwable)e);
                if (stack.contains("net.schmizz.sshj.sftp.RemoteFile.write")) {
                    log.warn("Failed to transfer " + urlToInstall + " to " + machine + ", retryable error, attempt " + attemptNum + "/" + numAttempts + ": " + e);
                    continue;
                }
                log.warn("Failed to transfer " + urlToInstall + " to " + machine + ", not a retryable error so failing: " + e);
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                Tasks.resetBlockingDetails();
            }
        } while (retriesRemaining-- > 0);
        throw Exceptions.propagate((Throwable)lastError);
    }

    public static String readFullyString(File sourceFile) {
        try {
            return Files.toString((File)sourceFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException ioe) {
            throw Exceptions.propagate((Throwable)ioe);
        }
    }

    public static void extractZip(ZipFile zip, String targetFolder) {
        File targetPath = new File(targetFolder);
        targetPath.mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        try {
            String canonicalDestinationDirPath = targetPath.getCanonicalPath();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String originalName = entry.getName();
                File destFile = new File(targetPath, originalName);
                String sanitizedName = originalName.replace("\\", File.separator).replace("/", File.separator);
                File sanitizedDestFile = new File(targetPath, sanitizedName);
                String canonicalDestinationFile = sanitizedDestFile.getCanonicalPath();
                if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
                    throw new IllegalStateException("Entry is outside of the target dir: " + entry.getName());
                }
                destFile.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(destFile);
                    Throwable throwable2 = null;
                    try {
                        Streams.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static enum ArchiveType {
        TAR,
        TGZ,
        TBZ,
        ZIP,
        JAR,
        WAR,
        EAR,
        UNKNOWN;

        public static Set<ArchiveType> ZIP_ARCHIVES;

        public static ArchiveType of(String filename) {
            if (filename == null) {
                return null;
            }
            String ext = Files.getFileExtension((String)filename);
            try {
                return ArchiveType.valueOf(ext.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                if (filename.toLowerCase().endsWith(".tar.gz")) {
                    return TGZ;
                }
                if (filename.toLowerCase().endsWith(".tar.bz") || filename.toLowerCase().endsWith(".tar.bz2") || filename.toLowerCase().endsWith(".tar.xz")) {
                    return TBZ;
                }
                return UNKNOWN;
            }
        }

        public String toString() {
            if (UNKNOWN.equals((Object)this)) {
                return "";
            }
            return this.name().toLowerCase();
        }

        static {
            ZIP_ARCHIVES = EnumSet.of(ZIP, JAR, WAR, EAR);
        }
    }
}

