/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextFluent;

public class ContextBuilder
extends ContextFluent<ContextBuilder>
implements VisitableBuilder<Context, ContextBuilder> {
    ContextFluent<?> fluent;
    Boolean validationEnabled;

    public ContextBuilder() {
        this(false);
    }

    public ContextBuilder(Boolean validationEnabled) {
        this(new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContextBuilder(ContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance) {
        this(fluent, instance, false);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Context context = instance = instance != null ? instance : new Context();
        if (instance != null) {
            fluent.withCluster(instance.getCluster());
            fluent.withExtensions(instance.getExtensions());
            fluent.withNamespace(instance.getNamespace());
            fluent.withUser(instance.getUser());
            fluent.withCluster(instance.getCluster());
            fluent.withExtensions(instance.getExtensions());
            fluent.withNamespace(instance.getNamespace());
            fluent.withUser(instance.getUser());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContextBuilder(Context instance) {
        this(instance, (Boolean)false);
    }

    public ContextBuilder(Context instance, Boolean validationEnabled) {
        this.fluent = this;
        Context context = instance = instance != null ? instance : new Context();
        if (instance != null) {
            this.withCluster(instance.getCluster());
            this.withExtensions(instance.getExtensions());
            this.withNamespace(instance.getNamespace());
            this.withUser(instance.getUser());
            this.withCluster(instance.getCluster());
            this.withExtensions(instance.getExtensions());
            this.withNamespace(instance.getNamespace());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Context build() {
        Context buildable = new Context(this.fluent.getCluster(), this.fluent.buildExtensions(), this.fluent.getNamespace(), this.fluent.getUser());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

