/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConstraintViolationException;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.entitlement.EntitlementPredicates;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.IdAlreadyExistsException;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.rest.api.ApplicationApi;
import org.apache.brooklyn.rest.domain.ApplicationSpec;
import org.apache.brooklyn.rest.domain.ApplicationSummary;
import org.apache.brooklyn.rest.domain.EntityDetail;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.ApplicationTransformer;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.EntityAttributesUtils;
import org.apache.brooklyn.rest.util.EntityRelationUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class ApplicationResource
extends AbstractBrooklynRestResource
implements ApplicationApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationResource.class);
    private static final String AUTHORIZATION_ERR_MSG = "User '%s' is not authorized to start application %s";
    @Context
    private UriInfo uriInfo;

    private EntitySummary fromEntity(Entity entity, boolean includeTags, int detailDepth, List<String> extraSensorGlobs, List<String> extraConfigGlobs) {
        Collection memberEntities;
        if (detailDepth == 0) {
            return new EntitySummary(entity.getId(), entity.getDisplayName(), entity.getEntityType().getName(), entity.getCatalogItemId(), (Map)MutableMap.of((Object)"self", (Object)EntityTransformer.entityUri(entity, this.ui.getBaseUriBuilder())));
        }
        Boolean serviceUp = (Boolean)EntityAttributesUtils.tryGetAttribute(entity, Attributes.SERVICE_UP);
        Lifecycle serviceState = (Lifecycle)EntityAttributesUtils.tryGetAttribute(entity, Attributes.SERVICE_STATE_ACTUAL);
        String iconUrl = RegisteredTypes.getIconUrl((BrooklynObject)entity);
        if (iconUrl != null && this.brooklyn().isUrlServerSideAndSafe(iconUrl)) {
            iconUrl = EntityTransformer.entityUri(entity, this.ui.getBaseUriBuilder()) + "/icon";
        }
        ArrayList children = Lists.newArrayList();
        if (!entity.getChildren().isEmpty()) {
            for (Entity child : entity.getChildren()) {
                if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)child)) continue;
                children.add(this.fromEntity(child, includeTags, detailDepth - 1, extraSensorGlobs, extraConfigGlobs));
            }
        }
        String parentId = null;
        if (entity.getParent() != null) {
            parentId = entity.getParent().getId();
        }
        ArrayList groupIds = Lists.newArrayList();
        if (!entity.groups().isEmpty()) {
            groupIds.addAll(this.entitiesIdAsArray((Iterable<? extends Entity>)entity.groups()));
        }
        ArrayList members = Lists.newArrayList();
        if (entity instanceof Group && (memberEntities = (Collection)EntityAttributesUtils.tryGetAttribute(entity, AbstractGroup.GROUP_MEMBERS)) != null && !memberEntities.isEmpty()) {
            members.addAll(this.entitiesIdAndNameAsList(memberEntities));
        }
        EntityDetail result = new EntityDetail(entity.getApplicationId(), entity.getId(), parentId, entity.getDisplayName(), entity.getEntityType().getName(), serviceUp, serviceState, iconUrl, entity.getCatalogItemId(), (List)children, (List)groupIds, (List)members, (Map)MutableMap.of((Object)"self", (Object)EntityTransformer.entityUri(entity, this.ui.getBaseUriBuilder())));
        if (includeTags) {
            result.setExtraField("tags", this.resolving(MutableList.copyOf((Iterable)entity.tags().getTags())).preferJson(true).resolve());
        }
        result.setExtraField("creationTimeUtc", (Object)entity.getCreationTime());
        this.addSensorsByGlobs((EntitySummary)result, entity, extraSensorGlobs);
        this.addConfigByGlobs((EntitySummary)result, entity, extraConfigGlobs);
        result.setExtraField("relations", EntityRelationUtils.getRelations(entity));
        return result;
    }

    private List<Map<String, String>> entitiesIdAndNameAsList(Collection<? extends Entity> entities) {
        ArrayList members = Lists.newArrayList();
        for (Entity entity : entities) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
            members.add(ImmutableMap.of((Object)"id", (Object)entity.getId(), (Object)"name", (Object)entity.getDisplayName()));
        }
        return members;
    }

    private List<String> entitiesIdAsArray(Iterable<? extends Entity> entities) {
        ArrayList ids = Lists.newArrayList();
        for (Entity entity : entities) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
            ids.add(entity.getId());
        }
        return ids;
    }

    public List<EntityDetail> fetch(String entityIds, String extraSensorsS) {
        List extraSensorNames = StringEscapes.JavaStringEscapes.unwrapOptionallyQuotedJavaStringList((String)extraSensorsS);
        List<AttributeSensor<?>> extraSensors = extraSensorNames.stream().map(s -> Sensors.newSensor(Object.class, (String)s)).collect(Collectors.toList());
        ArrayList entitySummaries = Lists.newArrayList();
        for (Entity application : this.mgmt().getApplications()) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)application)) continue;
            entitySummaries.add(this.addSensorsByName((EntityDetail)this.fromEntity(application, false, -1, null, null), application, extraSensors));
        }
        if (Strings.isNonBlank((CharSequence)entityIds)) {
            List extraEntities = StringEscapes.JavaStringEscapes.unwrapOptionallyQuotedJavaStringList((String)entityIds);
            for (String entityId : extraEntities) {
                for (Entity entity = this.mgmt().getEntityManager().getEntity(entityId.trim()); entity != null && entity.getParent() != null; entity = entity.getParent()) {
                    if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
                    entitySummaries.add(this.addSensorsByName((EntityDetail)this.fromEntity(entity, false, -1, null, null), entity, extraSensors));
                }
            }
        }
        return entitySummaries;
    }

    public List<EntitySummary> details(String entityIds, boolean includeAllApps, String extraSensorsGlobsS, String extraConfigGlobsS, int depth) {
        List extraSensorGlobs = StringEscapes.JavaStringEscapes.unwrapOptionallyQuotedJavaStringList((String)extraSensorsGlobsS);
        List extraConfigGlobs = StringEscapes.JavaStringEscapes.unwrapOptionallyQuotedJavaStringList((String)extraConfigGlobsS);
        MutableMap entitySummaries = MutableMap.of();
        if (includeAllApps) {
            for (Entity application : this.mgmt().getApplications()) {
                if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)application)) continue;
                entitySummaries.put(application.getId(), this.fromEntity(application, true, depth, extraSensorGlobs, extraConfigGlobs));
            }
        }
        if (Strings.isNonBlank((CharSequence)entityIds)) {
            List extraEntities = StringEscapes.JavaStringEscapes.unwrapOptionallyQuotedJavaStringList((String)entityIds);
            for (String entityId : extraEntities) {
                for (Entity entity = this.mgmt().getEntityManager().getEntity(entityId.trim()); entity != null && !entitySummaries.containsKey(entity.getId()); entity = entity.getParent()) {
                    if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
                    entitySummaries.put(entity.getId(), this.fromEntity(entity, true, depth, extraSensorGlobs, extraConfigGlobs));
                }
            }
        }
        return MutableList.copyOf(entitySummaries.values());
    }

    private EntityDetail addSensorsByName(EntityDetail result, Entity entity, List<AttributeSensor<?>> extraSensors) {
        if (extraSensors != null && !extraSensors.isEmpty()) {
            Object sensorsO = result.getExtraFields().get("sensors");
            if (sensorsO == null) {
                sensorsO = MutableMap.of();
                result.setExtraField("sensors", sensorsO);
            }
            if (!(sensorsO instanceof Map)) {
                throw new IllegalStateException("sensors field in result for " + entity + " should be a Map; found: " + sensorsO);
            }
            Map sensors = (Map)sensorsO;
            for (AttributeSensor<?> s : extraSensors) {
                Object sv;
                if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_SENSOR, (Object)new Entitlements.EntityAndItem(entity, (Object)s.getName())) || (sv = entity.sensors().get(s)) == null) continue;
                sv = this.resolving(sv).preferJson(true).asJerseyOutermostReturnValue(false).useDisplayHints(false).context(entity).immediately(true).timeout(Duration.ZERO).resolve();
                sensors.put(s.getName(), sv);
            }
        }
        return result;
    }

    private EntitySummary addSensorsByGlobs(EntitySummary result, Entity entity, List<String> extraSensorGlobs) {
        if (extraSensorGlobs != null && !extraSensorGlobs.isEmpty()) {
            Object sensorsO = result.getExtraFields().get("sensors");
            if (sensorsO == null) {
                sensorsO = MutableMap.of();
                result.setExtraField("sensors", sensorsO);
            }
            if (!(sensorsO instanceof Map)) {
                throw new IllegalStateException("sensors field in result for " + entity + " should be a Map; found: " + sensorsO);
            }
            Map sensors = (Map)sensorsO;
            Map svs = entity.sensors().getAll();
            svs.entrySet().stream().forEach(kv -> {
                Object sv = kv.getValue();
                if (sv != null) {
                    String name = ((AttributeSensor)kv.getKey()).getName();
                    if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_SENSOR, (Object)new Entitlements.EntityAndItem(entity, (Object)name)) && extraSensorGlobs.stream().anyMatch(sn -> WildcardGlobs.isGlobMatched((String)sn, (String)name))) {
                        sv = this.resolving(sv).preferJson(true).asJerseyOutermostReturnValue(false).useDisplayHints(false).context(entity).immediately(true).timeout(Duration.ZERO).resolve();
                        sensors.put(name, sv);
                    }
                }
            });
        }
        return result;
    }

    private EntitySummary addConfigByGlobs(EntitySummary result, Entity entity, List<String> extraConfigGlobs) {
        if (extraConfigGlobs != null && !extraConfigGlobs.isEmpty()) {
            Object configO = result.getExtraFields().get("config");
            if (configO == null) {
                configO = MutableMap.of();
                result.setExtraField("config", configO);
            }
            if (!(configO instanceof Map)) {
                throw new IllegalStateException("config field in result for " + entity + " should be a Map; found: " + configO);
            }
            Map configs = (Map)configO;
            MutableList extraConfigPreds = MutableList.of();
            extraConfigGlobs.stream().forEach(arg_0 -> ApplicationResource.lambda$addConfigByGlobs$3((List)extraConfigPreds, arg_0));
            entity.config().findKeysDeclared(Predicates.or((Iterable)extraConfigPreds)).forEach(key -> {
                if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CONFIG, (Object)new Entitlements.EntityAndItem(entity, (Object)key.getName()))) {
                    Object v;
                    Maybe vRaw = ((EntityInternal)entity).config().getRaw(key);
                    Object object = v = vRaw.isPresent() ? vRaw.get() : entity.config().get(key);
                    if (v != null) {
                        v = this.resolving(v, this.mgmt()).preferJson(true).asJerseyOutermostReturnValue(false).useDisplayHints(false).context(entity).immediately(true).timeout(Duration.ZERO).resolve();
                        configs.put(key.getName(), v);
                    }
                }
            });
        }
        return result;
    }

    public List<ApplicationSummary> list(String typeRegex) {
        if (Strings.isBlank((CharSequence)typeRegex)) {
            typeRegex = ".*";
        }
        return FluentIterable.from((Iterable)this.mgmt().getApplications()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).filter(EntityPredicates.hasInterfaceMatching((String)typeRegex)).transform(ApplicationTransformer.fromApplication(this.ui.getBaseUriBuilder())).toList();
    }

    public ApplicationSummary get(String application) {
        return ApplicationTransformer.summaryFromApplication(this.brooklyn().getApplication(application), this.ui.getBaseUriBuilder());
    }

    @Deprecated
    protected Response createFromAppSpec(ApplicationSpec applicationSpec) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, (Object)applicationSpec)) {
            throw WebResourceUtils.forbidden(AUTHORIZATION_ERR_MSG, Entitlements.getEntitlementContext().user(), applicationSpec);
        }
        this.checkApplicationTypesAreValid(applicationSpec);
        this.checkLocationsAreValid(applicationSpec);
        List<Location> locations = this.brooklyn().getLocationsManaged(applicationSpec);
        Application app = this.brooklyn().create(applicationSpec);
        Task<?> t = this.brooklyn().start(app, locations);
        ApplicationResource.waitForStart(app, Duration.millis((Number)100));
        TaskSummary ts = TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), false).apply(t);
        URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(this.uriInfo.getBaseUriBuilder(), ApplicationApi.class, "get").build(new Object[]{app.getApplicationId()});
        return Response.created((URI)ref).entity((Object)ts).build();
    }

    public Response createFromYaml(String yaml) {
        return this.createFromYaml(yaml, null, (Optional<String>)Optional.absent());
    }

    public Response createFromYamlWithAppId(String yaml, String appId) {
        return this.createFromYaml(yaml, null, (Optional<String>)Optional.of((Object)appId));
    }

    public Response createFromYamlAndAppId(String yaml, String appId) {
        return this.createFromYamlAndFormatAndAppId(yaml, null, appId);
    }

    public Response createFromYamlAndFormatAndAppIdForm(String yaml, String format, String appId) {
        return this.createFromYamlAndFormatAndAppId(yaml, format, appId);
    }

    public Response createFromYamlAndFormatAndAppIdMultipart(String yaml, String format, String appId) {
        return this.createFromYamlAndFormatAndAppId(yaml, format, appId);
    }

    public Response createFromYamlAndFormatAndAppId(String yaml, String format, String appId) {
        return this.createFromYaml(yaml, format, (Optional<String>)Optional.of((Object)appId));
    }

    protected Response createFromYaml(String yaml, String format, Optional<String> appId) {
        EntitySpec<? extends Application> spec;
        Preconditions.checkNotNull((Object)yaml, (Object)"Blueprint must not be null");
        URI uri = null;
        try {
            String yamlUrl = yaml.trim();
            if (Urls.isUrlWithProtocol((String)yamlUrl)) {
                uri = new URI(yamlUrl);
            }
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (uri != null) {
            log.debug("Create app called with URI; retrieving contents: {}", uri);
            try {
                yaml = ResourceUtils.create((Object)this.mgmt()).getResourceAsString(uri.toString());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new UserFacingException("Cannot resolve URL: " + uri, (Throwable)e);
            }
        }
        log.debug("Creating app from yaml:\n{}", (Object)Sanitizer.sanitizeMultilineString((String)yaml));
        try {
            spec = this.createEntitySpecForApplication(yaml, format);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Failed REST deployment, could not create spec: " + e);
            UserFacingException userFacing = (UserFacingException)Exceptions.getFirstThrowableOfType((Throwable)e, UserFacingException.class);
            if (userFacing != null) {
                log.debug("Throwing " + userFacing + ", wrapped in " + e);
                throw userFacing;
            }
            throw WebResourceUtils.badRequest(e, "Error in blueprint", new Object[0]);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, spec)) {
            throw WebResourceUtils.forbidden(AUTHORIZATION_ERR_MSG, Entitlements.getEntitlementContext().user(), yaml);
        }
        try {
            return this.launch(yaml, spec, appId);
        }
        catch (IdAlreadyExistsException e) {
            log.warn("Failed REST deployment launching " + spec + ": " + (Object)((Object)e));
            throw WebResourceUtils.throwWebApplicationException(Response.Status.CONFLICT, e, "Error launching blueprint, id already exists", new Object[0]);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Failed REST deployment launching " + spec + ": " + e);
            throw WebResourceUtils.badRequest(e, "Error launching blueprint", new Object[0]);
        }
    }

    private Response launch(String yaml, EntitySpec<? extends Application> spec, Optional<String> entityId) {
        return ApplicationResource.launch(yaml, spec, entityId, this.mgmt(), this.ui);
    }

    public static Response launch(String planForReference, EntitySpec<? extends Application> spec, Optional<String> entityId, ManagementContext mgmt, UriInfo ui) {
        try {
            Application app = EntityManagementUtils.createUnstarted((ManagementContext)mgmt, spec, entityId);
            boolean isEntitled = Entitlements.isEntitled((EntitlementManager)mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)app, (Object)Entitlements.StringAndArgument.of((String)Startable.START.getName(), null)));
            if (!isEntitled) {
                throw WebResourceUtils.forbidden(AUTHORIZATION_ERR_MSG, Entitlements.getEntitlementContext().user(), spec.getType());
            }
            EntityManagementUtils.CreationResult result = EntityManagementUtils.start((Application)app);
            ApplicationResource.waitForStart(app, Duration.millis((Number)100));
            log.info("Launched from plan: " + Sanitizer.sanitizeMultilineString((String)planForReference) + " -> " + app + " (" + result.task() + ")");
            URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(ui.getBaseUriBuilder(), ApplicationApi.class, "get").build(new Object[]{app.getApplicationId()});
            Response.ResponseBuilder response = Response.created((URI)ref);
            if (result.task() != null) {
                response.entity((Object)TaskTransformer.fromTask(ui.getBaseUriBuilder(), AbstractBrooklynRestResource.RestValueResolver.resolving(mgmt, null), false).apply(result.task()));
            }
            return response.build();
        }
        catch (ConstraintViolationException e) {
            throw new UserFacingException((Throwable)e);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static void waitForStart(final Application app, Duration timeout) {
        Repeater.create((String)"wait a bit for app start").every(Duration.millis((Number)10)).limitTimeTo(timeout).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Lifecycle state = (Lifecycle)EntityAttributesUtils.tryGetAttribute((Entity)app, Attributes.SERVICE_STATE_ACTUAL);
                if (state == Lifecycle.CREATED || state == Lifecycle.STOPPED) {
                    return false;
                }
                return true;
            }
        }).run();
    }

    public Response createPoly(byte[] inputToAutodetectType) {
        return this.createWithFormat(new String(inputToAutodetectType, StandardCharsets.UTF_8), null);
    }

    public Response createFromForm(String contents) {
        log.debug("Creating app from form");
        return this.createPoly(contents.getBytes());
    }

    public Response createFromBytes(byte[] plan) {
        return this.createPoly(plan);
    }

    public Response createWithFormatForm(String plan, String format) {
        return this.createWithFormat(plan, format);
    }

    public Response createWithFormatMultipart(String plan, String format) {
        return this.createWithFormat(plan, format);
    }

    public Response createWithFormat(String inputToAutodetectType, String format) {
        EntitySpec<? extends Application> spec;
        if (format != null) {
            format = format.trim();
        }
        log.debug("Creating app from autodetecting input");
        boolean looksLikeLegacy = false;
        Exception legacyFormatException = null;
        if (Strings.isBlank((CharSequence)format)) {
            try {
                ApplicationSpec appSpec = (ApplicationSpec)this.mapper().readValue(inputToAutodetectType, ApplicationSpec.class);
                if (appSpec.getType() != null || appSpec.getEntities() != null) {
                    looksLikeLegacy = true;
                }
                return this.createFromAppSpec(appSpec);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                legacyFormatException = e;
                log.debug("Input is not legacy ApplicationSpec JSON (will try others)");
            }
        }
        String potentialYaml = new String(inputToAutodetectType);
        try {
            spec = this.createEntitySpecForApplication(potentialYaml, format);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Failed REST deployment, could not create spec (autodetecting): " + e);
            throw WebResourceUtils.badRequest(e, "Error in blueprint", new Object[0]);
        }
        if (spec != null) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, spec)) {
                throw WebResourceUtils.forbidden(AUTHORIZATION_ERR_MSG, Entitlements.getEntitlementContext().user(), potentialYaml);
            }
            try {
                return this.launch(potentialYaml, spec, (Optional<String>)Optional.absent());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Failed REST deployment launching " + spec + ": " + e);
                throw WebResourceUtils.badRequest(e, "Error launching blueprint (autodetecting)", new Object[0]);
            }
        }
        if (looksLikeLegacy) {
            throw Exceptions.propagate((Throwable)legacyFormatException);
        }
        return Response.serverError().entity((Object)"Unsupported format; not able to autodetect.").build();
    }

    public Response delete(String application) {
        Application app = this.brooklyn().getApplication(application);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)app, (Object)Entitlements.StringAndArgument.of((String)"delete", null)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to delete application %s", Entitlements.getEntitlementContext().user(), app);
        }
        Task<?> t = this.brooklyn().destroy(app);
        TaskSummary ts = TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), false).apply(t);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)ts).build();
    }

    private EntitySpec<? extends Application> createEntitySpecForApplication(String potentialYaml, String format) {
        return EntityManagementUtils.createEntitySpecForApplication((ManagementContext)this.mgmt(), (String)format, (String)potentialYaml);
    }

    private void checkApplicationTypesAreValid(ApplicationSpec applicationSpec) {
        String appType = applicationSpec.getType();
        if (appType != null) {
            this.checkEntityTypeIsValid(appType);
            if (applicationSpec.getEntities() != null) {
                throw WebResourceUtils.preconditionFailed("Application given explicit type '%s' must not define entities", appType);
            }
            return;
        }
        for (org.apache.brooklyn.rest.domain.EntitySpec entitySpec : applicationSpec.getEntities()) {
            String entityType = entitySpec.getType();
            this.checkEntityTypeIsValid((String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType"));
        }
    }

    private void checkSpecTypeIsValid(String type, Class<? extends BrooklynObject> subType) {
        Maybe typeV = RegisteredTypes.tryValidate((RegisteredType)this.mgmt().getTypeRegistry().get(type), (RegisteredTypeLoadingContext)RegisteredTypeLoadingContexts.spec(subType));
        if (!typeV.isNull()) {
            typeV.get();
            return;
        }
        try {
            this.brooklyn().getCatalogClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            log.debug("Class not found for type '" + type + "'; reporting 404", (Throwable)e);
            throw WebResourceUtils.notFound("Undefined type '%s'", type);
        }
        log.info(JavaClassNames.simpleClassName(subType) + " type '{}' not defined in catalog but is on classpath; continuing", (Object)type);
    }

    private void checkEntityTypeIsValid(String type) {
        this.checkSpecTypeIsValid(type, Entity.class);
    }

    private void checkLocationsAreValid(ApplicationSpec applicationSpec) {
        for (String locationId : applicationSpec.getLocations()) {
            locationId = BrooklynRestResourceUtils.fixLocation(locationId);
            if (!this.brooklyn().getLocationRegistry().getLocationSpec(locationId).isAbsent() || this.brooklyn().getLocationRegistry().getDefinedLocationById(locationId) != null) continue;
            throw WebResourceUtils.notFound("Undefined location '%s'", locationId);
        }
    }

    public List<EntitySummary> getDescendants(String application, String typeRegex) {
        Application entity = this.brooklyn().getApplication(application);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see the descendants of entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        return EntityTransformer.entitySummaries(this.brooklyn().descendantsOfType(application, application, typeRegex), this.ui.getBaseUriBuilder());
    }

    public Map<String, Object> getDescendantsSensor(String application, String sensor, String typeRegex, Boolean suppressSecrets) {
        Application entity = this.brooklyn().getApplication(application);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see the value of sensor '%s' for descendants of entity '%s'", Entitlements.getEntitlementContext().user(), sensor, entity);
        }
        Iterable<Entity> descs = this.brooklyn().descendantsOfType(application, application, typeRegex);
        return ApplicationResource.getSensorMap(sensor, descs, this.resolving(null), suppressSecrets);
    }

    public static Map<String, Object> getSensorMap(String sensor, Iterable<Entity> descs, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets) {
        Entity potentialSource;
        if (Iterables.isEmpty(descs)) {
            return Collections.emptyMap();
        }
        MutableMap result = MutableMap.of();
        Iterator<Entity> di = descs.iterator();
        AttributeSensor s = null;
        while (di.hasNext() && (s = (potentialSource = di.next()).getEntityType().getSensor(sensor)) == null) {
        }
        if (s == null) {
            s = Sensors.newSensor(Object.class, (String)sensor);
        }
        if (!(s instanceof AttributeSensor)) {
            log.warn("Cannot retrieve non-attribute sensor " + s + " for entities; returning empty map");
            return result;
        }
        for (Entity e : descs) {
            Object v = EntityAttributesUtils.tryGetAttribute(e, s);
            if (v == null) continue;
            result.put(e.getId(), resolver.getValueForDisplay(v, true, false, suppressSecrets));
        }
        return result;
    }

    private static /* synthetic */ void lambda$addConfigByGlobs$3(List extraConfigPreds, String g) {
        extraConfigPreds.add(ConfigPredicates.nameMatchesGlob((String)g));
    }
}

