/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.yaml.Yamls;

public class DslUtils {
    public static boolean resolved(Object ... args) {
        if (args == null) {
            return true;
        }
        return DslUtils.resolved(Arrays.asList(args));
    }

    public static boolean resolved(Iterable<?> args) {
        if (args == null) {
            return true;
        }
        boolean allResolved = true;
        for (Object arg : args) {
            if (!(arg instanceof DeferredSupplier)) continue;
            allResolved = false;
            break;
        }
        return allResolved;
    }

    private static Object transformSpecialFlags(ManagementContext mgmt, AbstractBrooklynObjectSpec<?, ?> spec, Object v) {
        return new BrooklynComponentTemplateResolver.SpecialFlagsTransformer(CatalogUtils.newClassLoadingContext((ManagementContext)mgmt, (String)spec.getCatalogItemId(), (Collection)ImmutableList.of()), (Set<String>)MutableSet.of()).apply(v);
    }

    public static Object transformSpecialFlags(ManagementContext mgmt, BrooklynClassLoadingContext loadingContext, Object v) {
        return new BrooklynComponentTemplateResolver.SpecialFlagsTransformer(loadingContext, (Set<String>)MutableSet.of()).apply(v);
    }

    private static Optional<Object> resolveBrooklynDslValueInternal(Object originalValue, @Nullable TypeToken<?> desiredType, @Nullable ManagementContext mgmt, @Nullable AbstractBrooklynObjectSpec<?, ?> specForCatalogItemIdContext, boolean requireType) {
        if (originalValue == null) {
            return Optional.absent();
        }
        Object value = originalValue;
        if (mgmt != null) {
            if (value instanceof String && ((String)value).matches("\\$brooklyn:[A-Za-z_]+:\\s(?s).*")) {
                value = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)((String)value)));
            }
            value = DslUtils.parseBrooklynDsl(mgmt, value);
            if (specForCatalogItemIdContext != null) {
                value = DslUtils.transformSpecialFlags(mgmt, specForCatalogItemIdContext, value);
            }
        }
        if (!requireType && value instanceof DeferredSupplier) {
            return Optional.of((Object)value);
        }
        if (desiredType != null) {
            return Optional.of((Object)TypeCoercions.coerce((Object)value, desiredType));
        }
        return Optional.of((Object)value);
    }

    public static Object parseBrooklynDsl(ManagementContext mgmt, Object value) {
        ImmutableMap inputToPdpParse = ImmutableMap.of((Object)"dsl", (Object)value);
        Map resolvedConfigMap = BrooklynCampPlatform.findPlatform(mgmt).pdp().applyInterpreters((Map)inputToPdpParse);
        value = resolvedConfigMap.get("dsl");
        return value;
    }

    public static Optional<Object> resolveBrooklynDslValue(Object originalValue, @Nullable TypeToken<?> desiredType, @Nullable ManagementContext mgmt, @Nullable AbstractBrooklynObjectSpec<?, ?> specForCatalogItemIdContext) {
        return DslUtils.resolveBrooklynDslValueInternal(originalValue, desiredType, mgmt, specForCatalogItemIdContext, false);
    }

    public static <T> Optional<T> resolveNonDeferredBrooklynDslValue(Object originalValue, @Nullable TypeToken<T> desiredType, @Nullable ManagementContext mgmt, @Nullable AbstractBrooklynObjectSpec<?, ?> specForCatalogItemIdContext) {
        return DslUtils.resolveBrooklynDslValueInternal(originalValue, desiredType, mgmt, specForCatalogItemIdContext, true);
    }
}

